/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config.security;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import com.takeshi.annotation.SystemSecurity;
import com.takeshi.config.StaticConfig;
import com.takeshi.pojo.vo.ResponseDataVO;
import com.takeshi.util.GsonUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class EncodeResponseBodyAdvice
implements ResponseBodyAdvice<ResponseDataVO<Object>> {
    private static final Logger log = LoggerFactory.getLogger(EncodeResponseBodyAdvice.class);

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        SystemSecurity methodAnnotation = (SystemSecurity)methodParameter.getMethodAnnotation(SystemSecurity.class);
        if (Objects.nonNull(methodAnnotation)) {
            return methodAnnotation.outEncode();
        }
        SystemSecurity classAnnotation = (SystemSecurity)AnnotationUtil.getAnnotation((AnnotatedElement)methodParameter.getContainingClass(), SystemSecurity.class);
        if (Objects.nonNull(classAnnotation)) {
            return classAnnotation.outEncode();
        }
        return false;
    }

    public ResponseDataVO<Object> beforeBodyWrite(@Nullable ResponseDataVO<Object> body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (ObjUtil.isNotNull(body) && ObjUtil.isNotNull((Object)body.getData())) {
            String str = CharSequence.class.isAssignableFrom(body.getData().getClass()) ? (String)body.getData() : GsonUtil.toJson(body.getData());
            String data = StaticConfig.rsa.encryptBase64(str, KeyType.PrivateKey);
            body.setData(data);
        }
        return body;
    }
}

