/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config.security;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.takeshi.config.security.TakeshiHttpRequestWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.MDC;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

@Configuration
@Order(value=-2147483648)
public class TakeshiFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        MDC.put((String)"traceId", (String)IdUtil.fastSimpleUUID());
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            if (StrUtil.contains((CharSequence)httpServletRequest.getContentType(), (CharSequence)"multipart/form-data")) {
                httpServletRequest = new StandardServletMultipartResolver().resolveMultipart(httpServletRequest);
            }
            chain.doFilter((ServletRequest)TakeshiHttpRequestWrapper.build(httpServletRequest), response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        MDC.remove((String)"traceId");
    }
}

