/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.config.security;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.springframework.util.StreamUtils;

public class TakeshiHttpRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] bodyByte;

    private TakeshiHttpRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.bodyByte = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public static TakeshiHttpRequestWrapper build(HttpServletRequest request) throws IOException {
        return new TakeshiHttpRequestWrapper(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bodyByte);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }
}

