/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.constraintvalidators;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjUtil;
import com.takeshi.constraints.NumberDigits;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.math.BigDecimal;

public class NumberDigitsValidator
implements ConstraintValidator<NumberDigits, Number> {
    private int maxInteger = 0;
    private int minInteger = 0;
    private int maxFraction = 0;
    private int minFraction = 0;

    public void initialize(NumberDigits constraintAnnotation) {
        this.maxInteger = constraintAnnotation.maxInteger();
        this.minInteger = constraintAnnotation.minInteger();
        this.maxFraction = constraintAnnotation.maxFraction();
        this.minFraction = constraintAnnotation.minFraction();
    }

    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (ObjUtil.isNull((Object)value)) {
            return true;
        }
        BigDecimal bigDecimal = NumberUtil.toBigDecimal((Number)value);
        int integerPartLength = bigDecimal.precision() - bigDecimal.scale();
        int fractionPartLength = Math.max(bigDecimal.scale(), 0);
        boolean integerValid = this.minInteger <= integerPartLength && integerPartLength <= this.maxInteger;
        boolean fractionValid = this.minFraction <= fractionPartLength && fractionPartLength <= this.maxFraction;
        return integerValid && fractionValid;
    }
}

