/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.controller;

import cn.hutool.crypto.asymmetric.KeyType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.takeshi.annotation.SystemSecurity;
import com.takeshi.config.StaticConfig;
import com.takeshi.controller.BaseController;
import com.takeshi.pojo.vo.ResponseDataVO;
import com.takeshi.util.GsonUtil;
import com.takeshi.util.TakeshiUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system"})
@Hidden
@Tag(name="\u7cfb\u7edf\u63a5\u53e3")
@SystemSecurity(all=true)
public class SystemController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);

    @Operation(summary="\u4f7f\u7528\u516c\u94a5\u52a0\u5bc6\u6570\u636e")
    @ApiOperationSupport(author="Nanase Takeshi")
    @PostMapping(value={"/encrypt"})
    public ResponseDataVO<Object> encrypt(@RequestBody Object object) {
        String data = GsonUtil.toJson(object);
        log.info("SystemController.encrypt --> data: {}", (Object)data);
        return SystemController.success(StaticConfig.rsa.encryptBase64(data, KeyType.PublicKey));
    }

    @Operation(summary="\u4f7f\u7528\u516c\u94a5\u89e3\u5bc6\u6570\u636e")
    @ApiOperationSupport(author="Nanase Takeshi")
    @PostMapping(value={"/decrypt"})
    public ResponseDataVO<Object> decrypt(@RequestBody Object object) throws JsonProcessingException {
        String data = GsonUtil.toJson(object);
        log.info("SystemController.decrypt --> data: {}", (Object)data);
        return SystemController.success(new ObjectMapper().readTree(StaticConfig.rsa.decryptStr(data, KeyType.PublicKey)));
    }

    @Operation(summary="\u6d4b\u8bd5\u751f\u6210sign\u503c")
    @ApiOperationSupport(author="Nanase Takeshi")
    @RequestMapping(value={"/sign"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.DELETE, RequestMethod.PUT})
    public ResponseDataVO<Object> generate(HttpServletRequest request) {
        return SystemController.success(TakeshiUtil.signParams(request, new String[0]));
    }
}

