/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.takeshi.annotation.SystemSecurity;
import com.takeshi.constants.SysCode;
import com.takeshi.controller.BaseController;
import com.takeshi.pojo.vo.ResponseDataVO;
import com.takeshi.util.AmazonS3Util;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.util.List;
import org.apache.tika.mime.MimeTypeException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"/common/upload"})
@Tag(name="\u4e0a\u4f20\u6587\u4ef6")
public class UploadController
extends BaseController {
    @SystemSecurity(all=true)
    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6")
    @ApiOperationSupport(author="Nanase Takeshi")
    @PostMapping(value={"/file"})
    public ResponseDataVO<Object> uploadFile(@RequestPart MultipartFile file, @Parameter(description="\u662f\u5426\u540c\u6b65\u4e0a\u4f20") boolean sync) throws IOException, InterruptedException, MimeTypeException {
        if (file.isEmpty()) {
            return UploadController.success(SysCode.FILE_IS_NULL);
        }
        return UploadController.success(AmazonS3Util.addFile(file, sync));
    }

    @SystemSecurity(all=true)
    @Operation(summary="\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6", description="\u4e0a\u4f20\u591a\u4e2a\u6587\u4ef6\uff0c\u6700\u591a\u540c\u65f6\u4e0a\u4f209\u4e2a\u6587\u4ef6")
    @ApiOperationSupport(author="Nanase Takeshi")
    @PostMapping(value={"/multi-file"})
    public ResponseDataVO<List<String>> uploadFile(@RequestPart @NotEmpty @Size(min=1, max=9) @NotEmpty @Size(min=1, max=9) MultipartFile[] files, @Parameter(description="\u662f\u5426\u540c\u6b65\u4e0a\u4f20") boolean sync) throws InterruptedException, IOException, MimeTypeException {
        return UploadController.success(AmazonS3Util.addFile(files, sync));
    }
}

