/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.exception;

import cn.dev33.satoken.exception.DisableServiceException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.json.JSONUtil;
import com.takeshi.constants.SysCode;
import com.takeshi.exception.TakeshiException;
import com.takeshi.pojo.vo.ResponseDataVO;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String SQL_CAUSE = "java.sql.SQL";

    @ExceptionHandler(value={Exception.class})
    public ResponseDataVO<Object> exceptionHandler(Exception exception) {
        log.error("GlobalExceptionHandler.exceptionHandler --> Exception: ", (Throwable)exception);
        if (exception.getCause().toString().startsWith(SQL_CAUSE)) {
            return ResponseDataVO.success(SysCode.DB_ERROR);
        }
        return ResponseDataVO.fail(exception.getMessage());
    }

    @ExceptionHandler(value={SQLException.class, DataAccessException.class})
    public ResponseDataVO<Object> sqlExceptionHandler(Exception exception) {
        log.error("GlobalExceptionHandler.sqlExceptionHandler --> SQLException: ", (Throwable)exception);
        return ResponseDataVO.success(SysCode.DB_ERROR);
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseDataVO<Object> runtimeExceptionHandler(RuntimeException runtimeException) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)runtimeException);
        if (rootCause instanceof NullPointerException) {
            log.error("GlobalExceptionHandler.runtimeExceptionHandler --> NullPointerException: ", rootCause);
            return ResponseDataVO.success(SysCode.SYS_NULL_POINT);
        }
        if (rootCause instanceof SQLException) {
            log.error("GlobalExceptionHandler.runtimeExceptionHandler --> SQLException: ", rootCause);
            return ResponseDataVO.success(SysCode.DB_ERROR);
        }
        if (rootCause instanceof NoSuchElementException) {
            log.error("GlobalExceptionHandler.runtimeExceptionHandler --> NoSuchElementException: ", rootCause);
            return ResponseDataVO.success(SysCode.RESOURCE_DOES_NOT_EXIST);
        }
        if (rootCause instanceof TakeshiException) {
            log.error("GlobalExceptionHandler.takeshiExceptionHandler --> TakeshiException: ", rootCause);
            return (ResponseDataVO)JSONUtil.toBean((String)rootCause.getMessage(), (TypeReference)new TypeReference<ResponseDataVO<Object>>(){}, (boolean)false);
        }
        log.error("GlobalExceptionHandler.runtimeExceptionHandler --> RuntimeException: ", rootCause);
        return ResponseDataVO.fail(rootCause.getMessage());
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    public ResponseDataVO<Object> parameterBindHandler(BindException bindException) {
        log.error("GlobalExceptionHandler.parameterBindHandler --> BindException: ", (Throwable)bindException);
        BindingResult bindingResult = bindException.getBindingResult();
        FieldError fieldError = bindingResult.getFieldError();
        assert (fieldError != null);
        return ResponseDataVO.success(SysCode.PARAMETER_ERROR.getCode(), "[" + fieldError.getField() + "]" + fieldError.getDefaultMessage());
    }

    @ExceptionHandler(value={NotLoginException.class})
    public ResponseDataVO<Object> notLoginExceptionHandler(NotLoginException notLoginException) {
        log.error("GlobalExceptionHandler.notLoginExceptionHandler --> NotLoginException: ", (Throwable)notLoginException);
        if (notLoginException.getType().equals("-1")) {
            return ResponseDataVO.success(SysCode.NOT_TOKEN);
        }
        if (notLoginException.getType().equals("-2")) {
            return ResponseDataVO.success(SysCode.INVALID_TOKEN);
        }
        if (notLoginException.getType().equals("-3")) {
            return ResponseDataVO.success(SysCode.TOKEN_TIMEOUT);
        }
        if (notLoginException.getType().equals("-4")) {
            return ResponseDataVO.success(SysCode.BE_REPLACED);
        }
        if (notLoginException.getType().equals("-5")) {
            return ResponseDataVO.success(SysCode.KICK_OUT);
        }
        return ResponseDataVO.success(SysCode.NOT_LOGGED);
    }

    @ExceptionHandler(value={NotRoleException.class})
    public ResponseDataVO<Object> notRoleExceptionHandler(NotRoleException notRoleException) {
        log.error("GlobalExceptionHandler.notRoleExceptionHandler --> NotRoleException: ", (Throwable)notRoleException);
        return ResponseDataVO.success(SysCode.NOT_ROLE_EXCEPTION, new Object[]{notRoleException.getRole()});
    }

    @ExceptionHandler(value={NotPermissionException.class})
    public ResponseDataVO<Object> notPermissionExceptionHandler(NotPermissionException notPermissionException) {
        log.error("GlobalExceptionHandler.notPermissionExceptionHandler --> NotPermissionException: ", (Throwable)notPermissionException);
        return ResponseDataVO.success(SysCode.NOT_PERMISSION_EXCEPTION, new Object[]{notPermissionException.getPermission()});
    }

    @ExceptionHandler(value={DisableServiceException.class})
    public ResponseDataVO<Object> disableLoginExceptionHandler(DisableServiceException disableServiceException) {
        log.error("GlobalExceptionHandler.disableLoginExceptionHandler --> DisableLoginException: ", (Throwable)disableServiceException);
        return ResponseDataVO.success(SysCode.DISABLE_SERVICE_EXCEPTION, new Object[]{disableServiceException.getDisableTime()});
    }
}

