/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.function.Consumer;

public class BigDecimalSummaryStatistics
implements Consumer<BigDecimal> {
    private long count;
    private BigDecimal sum = BigDecimal.ZERO;
    private BigDecimal min;
    private BigDecimal max;

    @Override
    public void accept(BigDecimal value) {
        if (this.count == 0L) {
            Objects.requireNonNull(value);
            this.min = value;
            this.max = value;
        }
        ++this.count;
        this.sum = this.sum.add(value);
        this.min = this.min.min(value);
        this.max = this.max.max(value);
    }

    public void combine(BigDecimalSummaryStatistics other) {
        this.count += other.count;
        this.sum = this.sum.add(other.sum);
        this.min = this.min.min(other.min);
        this.max = this.max.max(other.max);
    }

    public final long getCount() {
        return this.count;
    }

    public final BigDecimal getSum() {
        return this.sum;
    }

    public final BigDecimal getMin() {
        return this.min;
    }

    public final BigDecimal getMax() {
        return this.max;
    }

    public final BigDecimal getAverage() {
        return this.getCount() > 0L ? this.getSum().divide(BigDecimal.valueOf(this.getCount()), RoundingMode.HALF_UP) : this.sum;
    }

    public final BigDecimal getAverage(RoundingMode roundingMode) {
        return this.getCount() > 0L ? this.getSum().divide(BigDecimal.valueOf(this.getCount()), roundingMode) : this.sum;
    }

    public final BigDecimal getAverage(MathContext mc) {
        return this.getCount() > 0L ? this.getSum().divide(BigDecimal.valueOf(this.getCount()), mc) : this.sum;
    }

    public String toString() {
        return this.count == 0L ? "empty" : String.format("%s{count=%d, sum=%f, min=%f, average=%f, max=%f}", this.getClass().getSimpleName(), this.getCount(), this.getSum(), this.getMin(), this.getAverage(), this.getMax());
    }
}

