/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.takeshi.constants.TakeshiDatePattern;
import java.lang.reflect.Type;
import java.time.LocalDateTime;

public class LocalDataTimeTypeAdapter
implements JsonSerializer<LocalDateTime>,
JsonDeserializer<LocalDateTime> {
    public LocalDateTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return LocalDateTime.parse(jsonElement.getAsString(), TakeshiDatePattern.NORM_DATETIME_FORMATTER);
    }

    public JsonElement serialize(LocalDateTime localDateTime, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(localDateTime.format(TakeshiDatePattern.NORM_DATETIME_FORMATTER));
    }
}

