/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.takeshi.constants.TakeshiDatePattern;
import java.lang.reflect.Type;
import java.time.MonthDay;

public class MonthDayTypeAdapter
implements JsonSerializer<MonthDay>,
JsonDeserializer<MonthDay> {
    public MonthDay deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return MonthDay.parse(jsonElement.getAsString(), TakeshiDatePattern.NORM_MONTH_DAY_FORMATTER);
    }

    public JsonElement serialize(MonthDay monthDay, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(monthDay.format(TakeshiDatePattern.NORM_MONTH_DAY_FORMATTER));
    }
}

