/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.jackson;

import cn.hutool.core.util.NumberUtil;
import com.takeshi.annotation.BigDecimalFormat;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

public class BigDecimalFormatAnnotationFormatterFactory
implements AnnotationFormatterFactory<BigDecimalFormat> {
    public Set<Class<?>> getFieldTypes() {
        return Collections.singleton(BigDecimal.class);
    }

    public Printer<?> getPrinter(BigDecimalFormat annotation, Class<?> fieldType) {
        return this.getFormatter(annotation);
    }

    public Parser<?> getParser(BigDecimalFormat annotation, Class<?> fieldType) {
        return this.getFormatter(annotation);
    }

    protected Formatter<BigDecimal> getFormatter(final BigDecimalFormat annotation) {
        return new Formatter<BigDecimal>(){

            public String print(BigDecimal object, Locale locale) {
                return NumberUtil.decimalFormat((String)annotation.pattern(), (Object)object);
            }

            public BigDecimal parse(String text, Locale locale) throws ParseException {
                return NumberUtil.toBigDecimal((String)text);
            }
        };
    }
}

