/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.mybatisplus;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.takeshi.mybatisplus.TakeshiMapper;
import com.takeshi.pojo.basic.AbstractBasicEntity;
import com.takeshi.pojo.basic.BasicSortPage;
import com.takeshi.pojo.basic.BasicSortQuery;
import com.takeshi.pojo.vo.ResponseDataVO;
import com.takeshi.util.TakeshiUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface ITakeshiService<T>
extends IService<T> {
    default public Page<T> buildSortPage(BasicSortPage basicSortPage) {
        Page page = Page.of((long)basicSortPage.getPageNum(), (long)basicSortPage.getPageSize());
        if (StrUtil.isNotBlank((CharSequence)basicSortPage.getSortColumn())) {
            page.addOrder(new OrderItem[]{new OrderItem(basicSortPage.getSortColumn(), BooleanUtil.isTrue((Boolean)basicSortPage.getSortAsc()))});
        }
        return page;
    }

    default public Page<T> page(BasicSortPage basicSortPage) {
        return (Page)this.getBaseMapper().selectPage(this.buildSortPage(basicSortPage), (Wrapper)Wrappers.emptyWrapper());
    }

    default public Page<T> listPage(BasicSortQuery baseQuery) {
        String createTime = TakeshiUtil.getColumnName(AbstractBasicEntity::getCreateTime);
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().ge(ObjUtil.isNotNull((Object)baseQuery.getStartTime()), (Object)createTime, (Object)baseQuery.getStartTime())).le(ObjUtil.isNotNull((Object)baseQuery.getEndTime()), (Object)createTime, (Object)baseQuery.getEndTime());
        return (Page)this.getBaseMapper().selectPage(this.buildSortPage(baseQuery), (Wrapper)queryWrapper);
    }

    default public Page<T> listPage(BasicSortQuery baseQuery, List<SFunction<T, ?>> columns) {
        String createTime = TakeshiUtil.getColumnName(AbstractBasicEntity::getCreateTime);
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().ge(ObjUtil.isNotNull((Object)baseQuery.getStartTime()), (Object)createTime, (Object)baseQuery.getStartTime())).le(ObjUtil.isNotNull((Object)baseQuery.getEndTime()), (Object)createTime, (Object)baseQuery.getEndTime());
        if (StrUtil.isNotBlank((CharSequence)baseQuery.getKeyword()) && CollUtil.isNotEmpty(columns)) {
            String sql = "CONCAT_WS(' '," + columns.stream().map(TakeshiUtil::getColumnName).collect(Collectors.joining(",")) + ") like '%" + baseQuery.getKeyword() + "%'";
            queryWrapper.apply(sql, new Object[0]);
        }
        return (Page)this.getBaseMapper().selectPage(this.buildSortPage(baseQuery), (Wrapper)queryWrapper);
    }

    default public Page<T> queryWrapperPage(BasicSortPage basicSortPage, Consumer<QueryWrapper<T>> consumer) {
        return (Page)this.getBaseMapper().selectPage(this.buildSortPage(basicSortPage), (Wrapper)new QueryWrapper().func(Objects.nonNull(consumer), consumer));
    }

    default public Page<T> lambdaQueryWrapperPage(BasicSortPage basicSortPage, Consumer<LambdaQueryWrapper<T>> consumer) {
        return (Page)this.getBaseMapper().selectPage(this.buildSortPage(basicSortPage), (Wrapper)new QueryWrapper().lambda().func(Objects.nonNull(consumer), consumer));
    }

    default public boolean columnExists(SFunction<T, ?> column, Object val) {
        return this.getBaseMapper().columnExists(column, val);
    }

    default public void columnExists(SFunction<T, ?> column, Object val, ResponseDataVO.ResBean resBean, Object ... args) {
        this.getBaseMapper().columnExists(column, val, resBean, args);
    }

    default public boolean columnExists(SFunction<T, ?> column, Object val, Serializable id) {
        return this.getBaseMapper().columnExists(column, val, id);
    }

    default public void columnExists(SFunction<T, ?> column, Object val, Serializable id, ResponseDataVO.ResBean resBean, Object ... args) {
        this.getBaseMapper().columnExists(column, val, id, resBean, args);
    }

    default public boolean update(Wrapper<T> updateWrapper) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.getEntityClass());
        return this.update(tableInfo.newInstance(), updateWrapper);
    }

    default public boolean updateColumnById(Serializable id, SFunction<T, ?> column, Serializable val) {
        return this.getBaseMapper().updateColumnById(id, column, val);
    }

    default public boolean logicDeleteById(Serializable id) {
        return this.getBaseMapper().logicDeleteById(id);
    }

    default public T getIncludeDelById(Serializable id) {
        return this.getBaseMapper().selectIncludeDelById(id);
    }

    public TakeshiMapper<T> getBaseMapper();
}

