/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.mybatisplus;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.ClassScanner;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.TypeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.takeshi.exception.TakeshiException;
import com.takeshi.pojo.vo.ResponseDataVO;
import com.takeshi.util.TakeshiUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public interface TakeshiMapper<T>
extends BaseMapper<T> {
    public static final Set<Class<?>> MAPPER_SET = ClassScanner.scanPackageBySuper((String)TakeshiMapper.class.getPackage().getName().replace("mybatisplus", "mapper"), TakeshiMapper.class);
    public static final int DEFAULT_BATCH_SIZE = 1000;

    default public <E> List<E> selectObjs(Wrapper<T> queryWrapper, Class<E> clazz) {
        return this.selectObjs(queryWrapper).stream().map(clazz::cast).collect(Collectors.toList());
    }

    public T selectIncludeDelById(Serializable var1);

    default public boolean insertWithSort(SFunction<T, ?> sortColumn, Integer val, Consumer<LambdaUpdateWrapper<T>> consumer) {
        String columnName = TakeshiUtil.getColumnName(sortColumn);
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().setSql(columnName + " = " + columnName + " + 1")).ge(sortColumn, (Object)val)).func(ObjUtil.isNotNull(consumer), consumer);
        return SqlHelper.retBool((Integer)this.update(null, (Wrapper)updateWrapper));
    }

    default public boolean deleteWithSort(Serializable id, SFunction<T, ?> sortColumn, Consumer<LambdaUpdateWrapper<T>> consumer) {
        Class<T> entityClass = this.getEntityClass();
        String columnName = TakeshiUtil.getColumnName(sortColumn);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        List ts = this.selectObjs((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)tableInfo.getKeyColumn(), (Object)id)).lambda().select(new SFunction[]{sortColumn}));
        if (CollUtil.isEmpty((Collection)ts)) {
            return false;
        }
        if (ts.size() != 1) {
            throw ExceptionUtils.mpe((String)"One record is expected, but the query result is multiple records", (Object[])new Object[0]);
        }
        Integer oldVal = (Integer)ts.get(0);
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().setSql(columnName + " = " + columnName + " - 1")).gt(sortColumn, (Object)oldVal)).func(ObjUtil.isNotNull(consumer), consumer);
        return SqlHelper.retBool((Integer)this.update(null, (Wrapper)updateWrapper));
    }

    default public boolean updateWithSort(Serializable id, SFunction<T, ?> sortColumn, Integer newVal, Consumer<LambdaUpdateWrapper<T>> consumer) {
        LambdaUpdateWrapper updateWrapper;
        Class<T> entityClass = this.getEntityClass();
        String columnName = TakeshiUtil.getColumnName(sortColumn);
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        List ts = this.selectObjs((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)tableInfo.getKeyColumn(), (Object)id)).lambda().select(new SFunction[]{sortColumn}));
        if (CollUtil.isEmpty((Collection)ts)) {
            return false;
        }
        if (ts.size() != 1) {
            throw ExceptionUtils.mpe((String)"One record is expected, but the query result is multiple records", (Object[])new Object[0]);
        }
        Integer oldVal = (Integer)ts.get(0);
        if (oldVal.compareTo(newVal) == 0) {
            return false;
        }
        updateWrapper.last((String)(StringUtils.isBlank((CharSequence)(updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(entityClass).setSql(columnName + " = CASE  WHEN " + tableInfo.getKeyColumn() + " = " + id + " THEN " + newVal + " WHEN " + columnName + " < " + oldVal + " THEN " + columnName + " + 1 WHEN " + columnName + " > " + oldVal + " THEN " + columnName + " - 1  ELSE " + columnName + " END")).func(ObjUtil.isNotNull(consumer), consumer)).getCustomSqlSegment()) ? " WHERE " : " and " + columnName + " >= LEAST(" + oldVal + "," + newVal + ") and " + columnName + " <= GREATEST(" + oldVal + "," + newVal + ")"));
        return SqlHelper.retBool((Integer)this.update(null, (Wrapper)updateWrapper));
    }

    default public boolean columnExists(SFunction<T, ?> column, Object val) {
        return this.exists((Wrapper)Wrappers.lambdaQuery(this.getEntityClass()).eq(column, val));
    }

    default public void columnExists(SFunction<T, ?> column, Object val, ResponseDataVO.ResBean resBean, Object ... args) {
        if (this.exists((Wrapper)Wrappers.lambdaQuery(this.getEntityClass()).eq(column, val))) {
            throw new TakeshiException(resBean, args);
        }
    }

    default public boolean columnExists(SFunction<T, ?> column, Object val, Serializable id) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        return this.exists((Wrapper)((QueryWrapper)new QueryWrapper().ne((Object)tableInfo.getKeyColumn(), (Object)id)).lambda().eq(column, val));
    }

    default public void columnExists(SFunction<T, ?> column, Object val, Serializable id, ResponseDataVO.ResBean resBean, Object ... args) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        if (this.exists((Wrapper)((QueryWrapper)new QueryWrapper().ne((Object)tableInfo.getKeyColumn(), (Object)id)).lambda().eq(column, val))) {
            throw new TakeshiException(resBean, args);
        }
    }

    default public boolean insertIgnore(Wrapper<T> queryWrapper, T entity) {
        if (null == entity) {
            return false;
        }
        if (this.exists(queryWrapper)) {
            return false;
        }
        return SqlHelper.retBool((Integer)this.insert(entity));
    }

    default public boolean insertOrUpdate(T entity) {
        if (null == entity) {
            return false;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        Object idVal = tableInfo.getPropertyValue(entity, tableInfo.getKeyProperty());
        return StringUtils.checkValNull((Object)idVal) || ObjUtil.isNull((Object)this.selectById((Serializable)idVal)) ? SqlHelper.retBool((Integer)this.insert(entity)) : SqlHelper.retBool((Integer)this.updateById(entity));
    }

    default public boolean insertOrUpdate(T entity, Wrapper<T> updateWrapper) {
        return SqlHelper.retBool((Integer)this.update(entity, updateWrapper)) || this.insertOrUpdate(entity);
    }

    default public boolean insertBatch(Collection<T> list) {
        return this.insertBatch(list, 1000);
    }

    default public boolean insertBatch(Collection<T> list, int batchSize) {
        Class<T> entityClass = this.getEntityClass();
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(entityClass, (Log)LogFactory.getLog(entityClass), list, (int)batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    default public boolean insertOrUpdateBatch(Collection<T> entityList) {
        return this.insertOrUpdateBatch(entityList, 1000);
    }

    default public boolean insertOrUpdateBatch(Collection<T> entityList, int batchSize) {
        Class<T> entityClass = this.getEntityClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        return SqlHelper.saveOrUpdateBatch(entityClass, this.getMapperClass(), (Log)LogFactory.getLog(entityClass), entityList, (int)batchSize, (sqlSession, entity) -> {
            Object idVal = tableInfo.getPropertyValue(entity, keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollUtil.isEmpty((Collection)sqlSession.selectList(this.getSqlStatement(SqlMethod.SELECT_BY_ID), entity));
        }, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(this.getSqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
        });
    }

    default public boolean update(Wrapper<T> updateWrapper) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        return SqlHelper.retBool((Integer)this.update(tableInfo.newInstance(), updateWrapper));
    }

    default public boolean updateColumnById(Serializable id, SFunction<T, ?> column, Serializable val) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)tableInfo.getKeyColumn(), (Object)id)).lambda().set(column, (Object)val);
        return SqlHelper.retBool((Integer)this.update(null, (Wrapper)updateWrapper));
    }

    default public boolean updateBatchById(Collection<T> entityList) {
        return this.updateBatchById(entityList, 1000);
    }

    default public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        Class<T> entityClass = this.getEntityClass();
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return SqlHelper.executeBatch(entityClass, (Log)LogFactory.getLog(entityClass), entityList, (int)batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    default public boolean logicDeleteById(Serializable id) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getEntityClass());
        if (tableInfo.isWithLogicDelete()) {
            Object instance = tableInfo.newInstance();
            tableInfo.setPropertyValue(instance, tableInfo.getKeyProperty(), new Object[]{id});
            return SqlHelper.retBool((Integer)this.deleteById(instance));
        }
        return SqlHelper.retBool((Integer)this.deleteById(id));
    }

    default public Class<T> getEntityClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), TakeshiMapper.class, (int)0);
    }

    default public Class<?> getMapperClass() {
        return MAPPER_SET.stream().filter(item -> TypeUtil.getTypeArgument((Type)item).equals(this.getEntityClass())).findFirst().orElseThrow(() -> new TakeshiException("Mapped Statements collection does not exist"));
    }

    default public String getSqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.getSqlStatement(this.getMapperClass(), (SqlMethod)sqlMethod);
    }
}

