/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.mybatisplus.typehandler;

import cn.hutool.core.util.ArrayUtil;
import com.takeshi.pojo.vo.GeoPointVO;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class GeoPointTypeHandler
extends BaseTypeHandler<GeoPointVO> {
    public void setNonNullParameter(PreparedStatement preparedStatement, int i, GeoPointVO geoPointVO, JdbcType jdbcType) throws SQLException {
        CoordinateArraySequence coordinateArraySequence = new CoordinateArraySequence(new Coordinate[]{new CoordinateXY(geoPointVO.getLon().doubleValue(), geoPointVO.getLat().doubleValue())});
        Point point = new Point((CoordinateSequence)coordinateArraySequence, new GeometryFactory());
        byte[] geometryBytes = new WKBWriter(2, 2, false).write((Geometry)point);
        byte[] wkb = new byte[geometryBytes.length + 4];
        wkb[3] = 0;
        wkb[2] = 0;
        wkb[1] = 0;
        wkb[0] = 0;
        System.arraycopy(geometryBytes, 0, wkb, 4, geometryBytes.length);
        preparedStatement.setBytes(i, wkb);
    }

    public GeoPointVO getNullableResult(ResultSet resultSet, String s) throws SQLException {
        return this.geoPointFromBytes(resultSet.getBytes(s));
    }

    public GeoPointVO getNullableResult(ResultSet resultSet, int i) throws SQLException {
        return this.geoPointFromBytes(resultSet.getBytes(i));
    }

    public GeoPointVO getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return this.geoPointFromBytes(callableStatement.getBytes(i));
    }

    private GeoPointVO geoPointFromBytes(byte[] bytes) {
        try {
            if (ArrayUtil.isEmpty((byte[])bytes)) {
                return null;
            }
            ByteArrayInStream byteArrayInStream = new ByteArrayInStream(bytes);
            byteArrayInStream.read(new byte[4]);
            WKBReader wkbReader = new WKBReader();
            Point point = wkbReader.read((InStream)byteArrayInStream).getInteriorPoint();
            return new GeoPointVO(point.getX(), point.getY());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

