/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.pojo.vo;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.takeshi.config.StaticConfig;
import com.takeshi.constants.SysCode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.MDC;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.annotation.Transient;

@Schema(name="\u63a5\u53e3\u8fd4\u56de\u503c\u5bf9\u8c61")
public class ResponseDataVO<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u72b6\u6001\u7801", example="200")
    private Integer code;
    @Schema(description="\u6d88\u606f")
    private String message;
    @Transient
    @JsonIgnore
    @Schema(hidden=true)
    private Object[] args;
    @Schema(description="\u9644\u52a0\u5bf9\u8c61")
    private T data;
    @Schema(description="\u8fd4\u56de\u65f6\u95f4\uff0c\u6beb\u79d2\u7ea7\u522b", example="1625101951214")
    private Long time;
    @Schema(description="\u65e5\u5fd7\u8ffd\u8e2aID")
    private String traceId;

    public static <T> ResponseDataVO<T> success() {
        return new ResponseDataVO<T>();
    }

    public static <T> ResponseDataVO<T> success(int code, String message) {
        return new ResponseDataVO<T>(code, message);
    }

    public static <T> ResponseDataVO<T> success(int code, String message, Object[] args) {
        return new ResponseDataVO<T>(code, message, args);
    }

    public static <T> ResponseDataVO<T> success(int code, String message, T data) {
        return new ResponseDataVO<T>(code, message, data);
    }

    public static <T> ResponseDataVO<T> success(int code, String message, T data, Object ... args) {
        return new ResponseDataVO<T>(code, message, data, args);
    }

    public static <T> ResponseDataVO<T> success(T data) {
        return new ResponseDataVO<T>(data);
    }

    public static <T> ResponseDataVO<T> success(ResBean resBean) {
        return new ResponseDataVO<T>(resBean);
    }

    public static <T> ResponseDataVO<T> success(ResBean resBean, Object[] args) {
        return new ResponseDataVO<T>(resBean, args);
    }

    public static <T> ResponseDataVO<T> success(ResBean resBean, T date) {
        return new ResponseDataVO<T>(resBean, date);
    }

    public static <T> ResponseDataVO<T> success(ResBean resBean, T date, Object ... args) {
        return new ResponseDataVO<T>(resBean, date, args);
    }

    public static <T> ResponseDataVO<T> retBool(boolean flag) {
        return flag ? ResponseDataVO.success() : ResponseDataVO.fail();
    }

    public static <T> ResponseDataVO<T> retBool(boolean flag, String failMessage, Object ... args) {
        return flag ? ResponseDataVO.success() : ResponseDataVO.fail(failMessage, args);
    }

    public static <T> ResponseDataVO<T> retBool(boolean flag, ResBean resBean, Object ... args) {
        return flag ? ResponseDataVO.success() : ResponseDataVO.success(resBean, args);
    }

    public static <T> ResponseDataVO<T> retBool(boolean flag, ResBean resBeanOfTrue, ResBean resBeanOfFalse) {
        return flag ? ResponseDataVO.success(resBeanOfTrue) : ResponseDataVO.success(resBeanOfFalse);
    }

    public static <T> ResponseDataVO<T> retBool(boolean flag, ResBean resBeanOfTrue, ResBean resBeanOfFalse, Object ... args) {
        return flag ? ResponseDataVO.success(resBeanOfTrue, args) : ResponseDataVO.success(resBeanOfFalse, args);
    }

    public static <T> ResponseDataVO<T> fail() {
        return new ResponseDataVO<T>(SysCode.FAIL);
    }

    public static <T> ResponseDataVO<T> fail(String message) {
        return new ResponseDataVO<T>(SysCode.FAIL.getCode(), message);
    }

    public static <T> ResponseDataVO<T> fail(String message, Object ... args) {
        return new ResponseDataVO<T>(SysCode.FAIL.getCode(), message, args);
    }

    private ResponseDataVO() {
        this.code = SysCode.SUCCESS.getCode();
        this.message = this.formatMessage(SysCode.SUCCESS.getInfo(), new Object[0]);
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(int code, String message) {
        this.code = code;
        this.message = this.formatMessage(message, new Object[0]);
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(int code, String message, Object[] args) {
        this.code = code;
        this.message = this.formatMessage(message, args);
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(int code, String message, T data) {
        this.code = code;
        this.message = this.formatMessage(message, new Object[0]);
        this.data = data;
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(int code, String message, T data, Object ... args) {
        this.code = code;
        this.message = this.formatMessage(message, args);
        this.data = data;
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(T data) {
        this.code = SysCode.SUCCESS.getCode();
        this.message = this.formatMessage(SysCode.SUCCESS.getInfo(), new Object[0]);
        this.data = data;
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(ResBean resCode) {
        this.code = resCode.getCode();
        this.message = this.formatMessage(resCode.getInfo(), new Object[0]);
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(ResBean resCode, Object[] args) {
        this.code = resCode.getCode();
        this.message = this.formatMessage(resCode.getInfo(), args);
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(ResBean resCode, T data) {
        this.code = resCode.getCode();
        this.message = this.formatMessage(resCode.getInfo(), new Object[0]);
        this.data = data;
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private ResponseDataVO(ResBean resCode, T data, Object ... args) {
        this.code = resCode.getCode();
        this.message = StrUtil.maxLength((CharSequence)this.formatMessage(resCode.getInfo(), args), (int)100);
        this.data = data;
        this.time = System.currentTimeMillis();
        this.traceId = MDC.get((String)"traceId");
    }

    private String formatMessage(String message, Object ... args) {
        return StaticConfig.messageSource.getMessage(message, args, message, LocaleContextHolder.getLocale());
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public T getData() {
        return this.data;
    }

    public Long getTime() {
        return this.time;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public void setArgs(Object[] args) {
        this.args = args;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseDataVO)) {
            return false;
        }
        ResponseDataVO other = (ResponseDataVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseDataVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseDataVO(code=" + this.getCode() + ", message=" + this.getMessage() + ", args=" + Arrays.deepToString(this.getArgs()) + ", data=" + this.getData() + ", time=" + this.getTime() + ", traceId=" + this.getTraceId() + ")";
    }

    public static class ResBean {
        private int code;
        private String info;

        public int getCode() {
            return this.code;
        }

        public String getInfo() {
            return this.info;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResBean)) {
                return false;
            }
            ResBean other = (ResBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$info = this.getInfo();
            String other$info = other.getInfo();
            return !(this$info == null ? other$info != null : !this$info.equals(other$info));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $info = this.getInfo();
            result = result * 59 + ($info == null ? 43 : $info.hashCode());
            return result;
        }

        public String toString() {
            return "ResponseDataVO.ResBean(code=" + this.getCode() + ", info=" + this.getInfo() + ")";
        }

        public ResBean(int code, String info) {
            this.code = code;
            this.info = info;
        }
    }
}

