/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.img.Img;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload;
import com.amazonaws.services.s3.model.BucketAccelerateConfiguration;
import com.amazonaws.services.s3.model.BucketAccelerateStatus;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PresignedUrlDownloadRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SetBucketAccelerateConfigurationRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.takeshi.config.StaticConfig;
import com.takeshi.config.properties.TakeshiProperties;
import com.takeshi.constants.SysCode;
import com.takeshi.exception.TakeshiException;
import com.takeshi.pojo.bo.SecretInfoBO;
import com.takeshi.pojo.vo.AmazonS3FileInfoVO;
import com.takeshi.util.GsonUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.springframework.web.multipart.MultipartFile;

public final class AmazonS3Util {
    private static final String ORIGINAL_NAME = "Original-Name";
    private static final String EXTENSION_NAME = "Extension-Name";
    private static final String CREATE_TIME = "Create-Time";
    private static String BUCKET_NAME;
    private static final MimeTypes MIME_REPOSITORY;
    public static volatile SecretInfoBO SECRET;
    private static volatile TransferManager transferManager;

    private AmazonS3Util() {
    }

    public static void deleteBucket(String bucketName) {
        transferManager.getAmazonS3Client().deleteBucket(bucketName);
    }

    public static String addCompressImg(File file, float quality) throws InterruptedException, IOException, MimeTypeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Img.from((File)file).setQuality(quality).write((OutputStream)byteArrayOutputStream);
        return AmazonS3Util.addFile(FileUtil.readBytes((File)file), file.getName());
    }

    public static String addFile(File file) throws InterruptedException, IOException, MimeTypeException {
        return AmazonS3Util.addFile(file, false);
    }

    public static String addFile(MultipartFile multipartFile) throws InterruptedException, IOException, MimeTypeException {
        return AmazonS3Util.addFile(multipartFile.getBytes(), multipartFile.getOriginalFilename());
    }

    public static String addFile(File file, boolean sync) throws InterruptedException, IOException, MimeTypeException {
        return AmazonS3Util.addFile(FileUtil.readBytes((File)file), file.getName(), sync);
    }

    public static String addFile(MultipartFile multipartFile, boolean sync) throws InterruptedException, IOException, MimeTypeException {
        return AmazonS3Util.addFile(multipartFile.getBytes(), multipartFile.getOriginalFilename(), sync);
    }

    public static String addFile(byte[] data, String fileName) throws IOException, InterruptedException, MimeTypeException {
        return AmazonS3Util.addFile(data, fileName, false);
    }

    public static String addFile(byte[] data, String fileName, boolean sync) throws InterruptedException, IOException, MimeTypeException {
        try (TikaInputStream tikaInputStream = TikaInputStream.get((byte[])data);){
            String mediaType = AmazonS3Util.getMediaType((InputStream)tikaInputStream, fileName);
            String extension = AmazonS3Util.getMimeType(mediaType).getExtension();
            if (StrUtil.isBlank((CharSequence)extension)) {
                throw new TakeshiException(SysCode.FILE_TYPE_ERROR);
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(tikaInputStream.getLength());
            metadata.setContentType(mediaType);
            metadata.addUserMetadata(ORIGINAL_NAME, FileNameUtil.mainName((String)fileName));
            metadata.addUserMetadata(CREATE_TIME, String.valueOf(Instant.now().toEpochMilli()));
            metadata.addUserMetadata(EXTENSION_NAME, extension);
            String fileObjKeyName = AmazonS3Util.getFileObjKeyName(extension);
            PutObjectRequest putObjectRequest = new PutObjectRequest(BUCKET_NAME, fileObjKeyName, (InputStream)tikaInputStream, metadata).withCannedAcl(CannedAccessControlList.PublicRead);
            Upload upload = transferManager.upload(putObjectRequest);
            if (sync) {
                upload.waitForCompletion();
            }
            String string = transferManager.getAmazonS3Client().getUrl(BUCKET_NAME, fileObjKeyName).toString();
            return string;
        }
    }

    public static List<String> addFile(MultipartFile[] multipartFiles, boolean sync) throws InterruptedException, IOException, MimeTypeException {
        ArrayList<String> list = new ArrayList<String>();
        for (MultipartFile item : multipartFiles) {
            list.add(AmazonS3Util.addFile(item, sync));
        }
        return list;
    }

    public static List<String> addFileList(File[] files) throws InterruptedException, IOException, MimeTypeException {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : files) {
            list.add(AmazonS3Util.addFile(file));
        }
        return list;
    }

    public static void deleteFile(String url) {
        transferManager.getAmazonS3Client().deleteObject(BUCKET_NAME, StrUtil.removePrefix((CharSequence)URLUtil.getPath((String)url), (CharSequence)"/"));
    }

    public static S3ObjectInputStream download(String url) {
        return transferManager.getAmazonS3Client().download(new PresignedUrlDownloadRequest(URLUtil.url((String)url))).getS3Object().getObjectContent();
    }

    public static void download(String url, File outFile) {
        transferManager.download(new PresignedUrlDownloadRequest(URLUtil.url((String)url)), outFile);
    }

    public static ObjectMetadata getObjectMetadata(String url) {
        String key = StrUtil.removePrefix((CharSequence)URLUtil.getPath((String)url), (CharSequence)"/");
        return transferManager.getAmazonS3Client().getObjectMetadata(BUCKET_NAME, key);
    }

    public static AmazonS3FileInfoVO getAmazonS3FileInfo(String url) {
        try {
            if (StrUtil.isBlank((CharSequence)url)) {
                return null;
            }
            ObjectMetadata objectMetadata = AmazonS3Util.getObjectMetadata(url);
            return new AmazonS3FileInfoVO(url, objectMetadata.getUserMetaDataOf(ORIGINAL_NAME), objectMetadata.getContentType(), objectMetadata.getUserMetaDataOf(EXTENSION_NAME), objectMetadata.getUserMetaDataOf(CREATE_TIME), objectMetadata.getContentLength());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFileObjKeyName(String extension) {
        return StrUtil.builder((CharSequence[])new CharSequence[]{extension, DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/"), IdUtil.getSnowflakeNextIdStr(), extension}).toString();
    }

    private static String getMediaType(InputStream stream, String fileName) throws IOException {
        Metadata metadata = new Metadata();
        metadata.add("resourceName", fileName);
        return MIME_REPOSITORY.detect(stream, metadata).toString();
    }

    private static MimeType getMimeType(String mediaType) throws MimeTypeException {
        return MIME_REPOSITORY.forName(mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        MIME_REPOSITORY = TikaConfig.getDefaultConfig().getMimeRepository();
        if (!ObjUtil.isNull((Object)transferManager)) return;
        Class<AmazonS3Util> clazz = AmazonS3Util.class;
        synchronized (AmazonS3Util.class) {
            if (!ObjUtil.isNull((Object)transferManager)) return;
            Assert.isTrue((boolean)ObjUtil.isNotNull((Object)StaticConfig.takeshiProperties), (String)StaticConfig.TAKESHI_PROPERTIES_MSG, (Object[])new Object[]{"awsCredentials"});
            TakeshiProperties.AWSSecretsManagerCredentials awsCredentials = StaticConfig.takeshiProperties.getAwsCredentials();
            BUCKET_NAME = awsCredentials.getBucketName();
            AWSSecretsManager awsSecretsManager = (AWSSecretsManager)((AWSSecretsManagerClientBuilder)((AWSSecretsManagerClientBuilder)AWSSecretsManagerClientBuilder.standard().withRegion(awsCredentials.getRegion())).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).build();
            GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest();
            getSecretValueRequest.setSecretId("Sharpish-key");
            GetSecretValueResult getSecretValueResult = awsSecretsManager.getSecretValue(getSecretValueRequest);
            String secret = StrUtil.isNotBlank((CharSequence)getSecretValueResult.getSecretString()) ? getSecretValueResult.getSecretString() : new String(Base64.getDecoder().decode(getSecretValueResult.getSecretBinary()).array());
            SECRET = GsonUtil.fromJson(secret, SecretInfoBO.class);
            String accessKey = SECRET.getAwsS3AccessKeyId();
            String secretKey = SECRET.getAwsS3SecretAccessKey();
            AmazonS3 amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).withRegion(awsCredentials.getRegion())).build();
            if (!amazonS3.doesBucketExistV2(BUCKET_NAME)) {
                amazonS3.createBucket(BUCKET_NAME);
                BucketLifecycleConfiguration.Rule lifecycleRule = new BucketLifecycleConfiguration.Rule().withId("Automatically delete incomplete multipart upload after seven days").withAbortIncompleteMultipartUpload(new AbortIncompleteMultipartUpload().withDaysAfterInitiation(7)).withStatus("Enabled");
                amazonS3.setBucketLifecycleConfiguration(BUCKET_NAME, new BucketLifecycleConfiguration().withRules(new BucketLifecycleConfiguration.Rule[]{lifecycleRule}));
                CORSRule corsRule = new CORSRule().withAllowedMethods(Collections.singletonList(CORSRule.AllowedMethods.GET)).withAllowedOrigins(Collections.singletonList("*"));
                amazonS3.setBucketCrossOriginConfiguration(BUCKET_NAME, new BucketCrossOriginConfiguration().withRules(new CORSRule[]{corsRule}));
                amazonS3.setBucketAccelerateConfiguration(new SetBucketAccelerateConfigurationRequest(BUCKET_NAME, new BucketAccelerateConfiguration(BucketAccelerateStatus.Enabled)));
            }
            transferManager = TransferManagerBuilder.standard().withS3Client(amazonS3).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

