/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.util.NumberUtil;
import com.takeshi.annotation.ToBigDecimalFunction;
import com.takeshi.function.BigDecimalSummaryStatistics;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class CollectorsUtil {
    private static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.emptySet();

    private CollectorsUtil() {
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return i -> i;
    }

    public static <T> Collector<T, ?, BigDecimalSummaryStatistics> summarizingBigDecimal(ToBigDecimalFunction<? super T> mapper) {
        return new CollectorImpl(BigDecimalSummaryStatistics::new, (r, t) -> r.accept(mapper.applyAsBigDecimal(t)), (l, r) -> {
            l.combine((BigDecimalSummaryStatistics)r);
            return l;
        }, CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, BigDecimal> summingBigDecimal(ToBigDecimalFunction<? super T> mapper) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{BigDecimal.ZERO}, (a, t) -> {
            a[0] = NumberUtil.add((Number)a[0], (Number)mapper.applyAsBigDecimal(t));
        }, (a, b) -> {
            a[0] = NumberUtil.add((Number)a[0], (Number)b[0]);
            return a;
        }, a -> a[0], CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, BigDecimal> maxBy(ToBigDecimalFunction<? super T> mapper) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{new BigDecimal(Integer.MIN_VALUE)}, (a, t) -> {
            a[0] = NumberUtil.max((BigDecimal[])new BigDecimal[]{a[0], mapper.applyAsBigDecimal(t)});
        }, (a, b) -> {
            a[0] = NumberUtil.max((BigDecimal[])new BigDecimal[]{a[0], b[0]});
            return a;
        }, a -> a[0], CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, BigDecimal> minBy(ToBigDecimalFunction<? super T> mapper) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{new BigDecimal(Integer.MAX_VALUE)}, (a, t) -> {
            a[0] = NumberUtil.min((BigDecimal[])new BigDecimal[]{a[0], mapper.applyAsBigDecimal(t)});
        }, (a, b) -> {
            a[0] = NumberUtil.min((BigDecimal[])new BigDecimal[]{a[0], b[0]});
            return a;
        }, a -> a[0], CHARACTERISTICS);
    }

    public static <T> Collector<T, ?, BigDecimal> averagingBigDecimal(ToBigDecimalFunction<? super T> mapper) {
        return CollectorsUtil.averagingBigDecimal(mapper, 2, RoundingMode.HALF_UP);
    }

    public static <T> Collector<T, ?, BigDecimal> averagingBigDecimal(ToBigDecimalFunction<? super T> mapper, int newScale, RoundingMode roundingMode) {
        return new CollectorImpl<Object, BigDecimal[], BigDecimal>(() -> new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO}, (a, t) -> {
            a[0] = NumberUtil.add((Number)a[0], (Number)mapper.applyAsBigDecimal(t));
            a[1] = NumberUtil.add((Number)a[1], (Number)BigDecimal.ONE);
        }, (a, b) -> {
            a[0] = NumberUtil.add((Number)a[0], (Number)b[0]);
            a[1] = NumberUtil.add((Number)a[1], (Number)b[1]);
            return a;
        }, a -> NumberUtil.equals((BigDecimal)a[1], (BigDecimal)BigDecimal.ZERO) ? BigDecimal.ZERO : NumberUtil.div((BigDecimal)a[0], (BigDecimal)a[1], (int)newScale, (RoundingMode)roundingMode), CHARACTERISTICS);
    }

    static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, CollectorsUtil.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

