/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.google.api.core.ApiFuture;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.messaging.AndroidConfig;
import com.google.firebase.messaging.AndroidNotification;
import com.google.firebase.messaging.ApnsConfig;
import com.google.firebase.messaging.Aps;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.MulticastMessage;
import com.google.firebase.messaging.Notification;
import com.takeshi.config.StaticConfig;
import com.takeshi.config.properties.TakeshiProperties;
import com.takeshi.util.GsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirebaseUtil {
    private static final Logger log = LoggerFactory.getLogger(FirebaseUtil.class);
    private static volatile FirebaseApp FIREBASE_APP;

    private FirebaseUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (!ObjUtil.isNull((Object)FIREBASE_APP)) return;
        Class<FirebaseUtil> clazz = FirebaseUtil.class;
        synchronized (FirebaseUtil.class) {
            if (!ObjUtil.isNull((Object)FIREBASE_APP)) return;
            try {
                Assert.isTrue((boolean)ObjUtil.isNotNull((Object)StaticConfig.takeshiProperties), (String)StaticConfig.TAKESHI_PROPERTIES_MSG, (Object[])new Object[]{"firebaseCredentials"});
                TakeshiProperties.FirebaseCredentials firebaseCredentials = StaticConfig.takeshiProperties.getFirebaseCredentials();
                String firebaseJsonFileName = StrUtil.blankToDefault((CharSequence)firebaseCredentials.getJsonFileName(), (String)"firebase.json");
                InputStream inputStream = ResourceUtil.getStreamSafe((String)firebaseJsonFileName);
                if (ObjUtil.isNull((Object)inputStream)) {
                    log.error("FirebaseUtil.static --> firebaseJsonFileName [{}] not found", (Object)firebaseJsonFileName);
                } else {
                    FirebaseOptions options = FirebaseOptions.builder().setCredentials(GoogleCredentials.fromStream((InputStream)inputStream)).setDatabaseUrl(firebaseCredentials.getDatabaseUrl()).build();
                    FIREBASE_APP = FirebaseApp.initializeApp((FirebaseOptions)options);
                    log.info("FirebaseUtil.static --> FirebaseApp \u521d\u59cb\u5316\u6210\u529f");
                }
            }
            catch (IOException e) {
                log.error("FirebaseUtil.static --> FirebaseApp \u521d\u59cb\u5316\u5931\u8d25, e: ", (Throwable)e);
            }
            return;
        }
    }

    public static final class Messaging {
        public static final FirebaseMessaging FIREBASE_MESSAGING = FirebaseMessaging.getInstance((FirebaseApp)FIREBASE_APP);

        private Messaging() {
        }

        public static ApiFuture<String> sendByTokenAsync(String token, String title, String body) {
            return FIREBASE_MESSAGING.sendAsync(Messaging.buildMessage(token, title, body, null, null));
        }

        public static ApiFuture<String> sendByTokenAsync(String token, String title, String body, Map<String, String> map) {
            return FIREBASE_MESSAGING.sendAsync(Messaging.buildMessage(token, title, body, map, null));
        }

        public static ApiFuture<String> sendByTokenAsync(String token, String title, String body, Map<String, String> map, String clickAction) {
            return FIREBASE_MESSAGING.sendAsync(Messaging.buildMessage(token, title, body, map, clickAction));
        }

        public static ApiFuture<BatchResponse> sendMulticastByTokensAsync(Collection<String> tokens, String title, String body) {
            return FIREBASE_MESSAGING.sendMulticastAsync(Messaging.buildMulticastMessage(tokens, title, body, null, null));
        }

        public static ApiFuture<BatchResponse> sendMulticastByTokensAsync(Collection<String> tokens, String title, String body, Map<String, String> map) {
            return FIREBASE_MESSAGING.sendMulticastAsync(Messaging.buildMulticastMessage(tokens, title, body, map, null));
        }

        public static ApiFuture<BatchResponse> sendMulticastByTokensAsync(Collection<String> tokens, String title, String body, Map<String, String> map, String clickAction) {
            return FIREBASE_MESSAGING.sendMulticastAsync(Messaging.buildMulticastMessage(tokens, title, body, map, clickAction));
        }

        private static Message buildMessage(String token, String title, String body, Map<String, String> map, String clickAction) {
            return Message.builder().setToken(token).setNotification(Notification.builder().setTitle(title).setBody(body).build()).setAndroidConfig(AndroidConfig.builder().setPriority(AndroidConfig.Priority.HIGH).setNotification(AndroidNotification.builder().setSound("default").setClickAction(clickAction).build()).build()).setApnsConfig(ApnsConfig.builder().putHeader("apns-priority", "10").setAps(Aps.builder().setSound("default").setCategory(clickAction).setBadge(1).build()).build()).putAllData(map).build();
        }

        private static MulticastMessage buildMulticastMessage(Collection<String> tokens, String title, String body, Map<String, String> map, String clickAction) {
            return MulticastMessage.builder().addAllTokens(tokens).setNotification(Notification.builder().setTitle(title).setBody(body).build()).setAndroidConfig(AndroidConfig.builder().setPriority(AndroidConfig.Priority.HIGH).setNotification(AndroidNotification.builder().setSound("default").setClickAction(clickAction).build()).build()).setApnsConfig(ApnsConfig.builder().putHeader("apns-priority", "10").setAps(Aps.builder().setSound("default").setCategory(clickAction).setBadge(1).build()).build()).putAllData(map).build();
        }
    }

    public static final class Database {
        public static final DatabaseReference DATABASE_REFERENCE = FirebaseDatabase.getInstance((FirebaseApp)FIREBASE_APP).getReference();

        private Database() {
        }

        public static ApiFuture<Void> setValueAsync(String pathString, Object value) {
            return DATABASE_REFERENCE.child(pathString).setValueAsync(GsonUtil.fromJson(GsonUtil.gsonLongToString().toJson(value), Object.class));
        }

        public static ApiFuture<Void> removeValueAsync(String pathString) {
            return DATABASE_REFERENCE.child(pathString).removeValueAsync();
        }
    }
}

