/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.LongSerializationPolicy;
import com.takeshi.gson.DateTimeTypeAdapter;
import com.takeshi.gson.LocalDataTimeTypeAdapter;
import com.takeshi.gson.LocalDataTypeAdapter;
import com.takeshi.gson.LocalTimeTypeAdapter;
import com.takeshi.gson.MonthDayTypeAdapter;
import com.takeshi.gson.OffsetDateTimeTypeAdapter;
import com.takeshi.gson.OffsetTimeTypeAdapter;
import com.takeshi.gson.YearMonthTypeAdapter;
import com.takeshi.gson.YearTypeAdapter;
import com.takeshi.gson.ZonedDateTimeTypeAdapter;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;

public final class GsonUtil {
    private static volatile Gson GSON = null;
    private static volatile Gson GSON_LONG_TO_STRING = null;
    private static volatile Gson GSON_INCLUDE_NULL = null;

    private GsonUtil() {
    }

    public static Gson gson() {
        return GSON;
    }

    public static Gson gsonLongToString() {
        return GSON_LONG_TO_STRING;
    }

    public static Gson gsonIncludeNull() {
        return GSON_INCLUDE_NULL;
    }

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }

    public static String toJson(Object src, boolean ignoreNullValue) {
        return ignoreNullValue ? GSON.toJson(src) : GSON_INCLUDE_NULL.toJson(src);
    }

    public static String toJson(Object src, Type typeOfSrc) {
        return GSON.toJson(src, typeOfSrc);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException {
        return (T)GSON.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfT) throws JsonSyntaxException {
        return (T)GSON.fromJson(json, typeOfT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (!ObjUtil.isNull((Object)GSON_INCLUDE_NULL)) return;
        Class<GsonUtil> clazz = GsonUtil.class;
        synchronized (GsonUtil.class) {
            if (!ObjUtil.isNull((Object)GSON_INCLUDE_NULL)) return;
            GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeAdapter()).registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeTypeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDataTypeAdapter()).registerTypeAdapter(LocalTime.class, (Object)new LocalTimeTypeAdapter()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDataTimeTypeAdapter()).registerTypeAdapter(Year.class, (Object)new YearTypeAdapter()).registerTypeAdapter(YearMonth.class, (Object)new YearMonthTypeAdapter()).registerTypeAdapter(MonthDay.class, (Object)new MonthDayTypeAdapter()).registerTypeAdapter(OffsetTime.class, (Object)new OffsetTimeTypeAdapter()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter());
            GSON = gsonBuilder.create();
            GSON_LONG_TO_STRING = gsonBuilder.setLongSerializationPolicy(LongSerializationPolicy.STRING).create();
            GSON_INCLUDE_NULL = gsonBuilder.serializeNulls().create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

