/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.microtripit.mandrillapp.lutung.MandrillApi;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillMessage;
import com.microtripit.mandrillapp.lutung.view.MandrillMessageStatus;
import com.takeshi.config.StaticConfig;
import com.takeshi.config.properties.TakeshiProperties;
import com.takeshi.exception.TakeshiException;
import com.takeshi.util.GsonUtil;
import com.takeshi.util.TemplateEngineUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MandrillUtil {
    private static final Logger log = LoggerFactory.getLogger(MandrillUtil.class);
    private static final String REJECTED = "rejected";
    private static final String INVALID = "invalid";
    private static volatile String FROM_EMAIL;
    private static volatile String FROM_NAME;
    private static volatile MandrillApi MANDRILL_API;
    private MandrillMessage message;
    private String subject;
    private String fromEmail;
    private String fromName;
    private String content;
    private boolean isHtml;
    private List<MandrillMessage.Recipient> to;
    private List<MandrillMessage.MessageContent> attachments;
    private List<MandrillMessage.MessageContent> images;

    private MandrillUtil() {
    }

    private MandrillUtil message() {
        this.message = new MandrillMessage();
        this.fromEmail = FROM_EMAIL;
        this.fromName = FROM_NAME;
        return this;
    }

    public static MandrillUtil create() {
        return new MandrillUtil().message();
    }

    public MandrillUtil subject(String subject) {
        this.subject = subject;
        return this;
    }

    public MandrillUtil from(String fromEmail, String fromName) {
        this.fromEmail = fromEmail;
        this.fromName = fromName;
        return this;
    }

    public MandrillUtil content(String content) {
        this.content = content;
        return this;
    }

    public MandrillUtil content(String content, boolean isHtml) {
        this.content = content;
        this.isHtml = isHtml;
        return this;
    }

    public MandrillUtil isHtml(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public MandrillUtil generateHtmlContent(String templateName, Map<?, ?> bindingMap) {
        String htmlStr = TemplateEngineUtil.engine.getTemplate(templateName + ".html").render(bindingMap);
        return this.content(htmlStr, true);
    }

    public MandrillUtil addRecipient(String email, String name) {
        this.to = (List)CollUtil.defaultIfEmpty(this.to, new ArrayList());
        MandrillMessage.Recipient recipient = new MandrillMessage.Recipient();
        recipient.setEmail(email);
        recipient.setName(name);
        this.to.add(recipient);
        return this;
    }

    public MandrillUtil addRecipient(String email, String name, MandrillMessage.Recipient.Type type) {
        this.to = (List)CollUtil.defaultIfEmpty(this.to, new ArrayList());
        MandrillMessage.Recipient recipient = new MandrillMessage.Recipient();
        recipient.setEmail(email);
        recipient.setName(name);
        recipient.setType(type);
        this.to.add(recipient);
        return this;
    }

    public MandrillUtil addRecipient(MandrillMessage.Recipient ... recipients) {
        this.to = (List)CollUtil.defaultIfEmpty(this.to, new ArrayList());
        this.to.addAll(Arrays.asList(recipients));
        return this;
    }

    public MandrillUtil addRecipient(List<MandrillMessage.Recipient> list) {
        this.to = (List)CollUtil.defaultIfEmpty(this.to, new ArrayList());
        this.to.addAll(list);
        return this;
    }

    public MandrillUtil addAttachment(File ... files) {
        this.attachments = (List)CollUtil.defaultIfEmpty(this.attachments, new ArrayList());
        for (File file : files) {
            MandrillMessage.MessageContent messageContent = new MandrillMessage.MessageContent();
            messageContent.setType(FileUtil.getMimeType((String)file.getName()));
            messageContent.setName(file.getName());
            messageContent.setContent(Base64.encode((File)file));
            this.attachments.add(messageContent);
        }
        return this;
    }

    public MandrillUtil addImages(File ... files) {
        this.images = (List)CollUtil.defaultIfEmpty(this.images, new ArrayList());
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : files) {
            MandrillMessage.MessageContent messageContent = new MandrillMessage.MessageContent();
            messageContent.setType(FileUtil.getMimeType((String)file.getName()));
            messageContent.setName(file.getName());
            messageContent.setContent(Base64.encode((File)file));
            this.images.add(messageContent);
            stringBuilder.append("<img src='cid:").append(file.getName()).append("' />");
        }
        this.content = this.content + stringBuilder.toString();
        return this.isHtml(true);
    }

    public void sendErr() {
        Object[] result;
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{this.subject, this.fromEmail, this.fromName}) || CollUtil.isEmpty(this.to)) {
            throw new TakeshiException("MandrillUtil send hasBlank: [subject, fromEmail, fromName, to]");
        }
        this.format();
        try {
            result = MANDRILL_API.messages().send(this.message, Boolean.valueOf(false));
        }
        catch (MandrillApiError | IOException mandrillApiError) {
            log.error("MandrillUtil.send --> mandrillApiError: ", mandrillApiError);
            throw new TakeshiException(mandrillApiError.getMessage());
        }
        if (ArrayUtil.isEmpty((Object[])result)) {
            throw new TakeshiException("MandrillUtil send result is empty");
        }
        if (StrUtil.equalsAny((CharSequence)result[0].getStatus(), (CharSequence[])new CharSequence[]{REJECTED, INVALID})) {
            throw new TakeshiException(GsonUtil.toJson(result));
        }
    }

    public void send() {
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{this.subject, this.fromEmail, this.fromName}) || CollUtil.isEmpty(this.to)) {
            log.error("MandrillUtil.send --> hasBlank: [subject, fromEmail, fromName, to]");
            return;
        }
        this.format();
        Object[] result = new MandrillMessageStatus[]{};
        try {
            result = MANDRILL_API.messages().send(this.message, Boolean.valueOf(false));
        }
        catch (MandrillApiError | IOException mandrillApiError) {
            log.error("MandrillUtil.send --> mandrillApiError: ", mandrillApiError);
        }
        if (ArrayUtil.isEmpty((Object[])result)) {
            log.error("MandrillUtil.send --> result is empty");
        }
        if (StrUtil.equalsAny((CharSequence)result[0].getStatus(), (CharSequence[])new CharSequence[]{REJECTED, INVALID})) {
            log.error("MandrillUtil.send --> result: {}", (Object)GsonUtil.toJson(result));
        }
    }

    private void format() {
        this.message.setSubject(this.subject);
        this.message.setFromEmail(this.fromEmail);
        this.message.setFromName(this.fromName);
        if (this.isHtml) {
            this.message.setHtml(this.content);
            this.message.setInlineCss(Boolean.valueOf(true));
        } else {
            this.message.setText(this.content);
        }
        this.message.setTo(this.to);
        this.message.setPreserveRecipients(Boolean.valueOf(true));
        if (CollUtil.isNotEmpty(this.attachments)) {
            this.message.setAttachments(this.attachments);
        }
        if (CollUtil.isNotEmpty(this.images)) {
            this.message.setImages(this.images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (!ObjUtil.isNull((Object)MANDRILL_API)) return;
        Class<MandrillUtil> clazz = MandrillUtil.class;
        synchronized (MandrillUtil.class) {
            if (!ObjUtil.isNull((Object)MANDRILL_API)) return;
            Assert.isTrue((boolean)ObjUtil.isNotNull((Object)StaticConfig.takeshiProperties), (String)StaticConfig.TAKESHI_PROPERTIES_MSG, (Object[])new Object[]{"mandrillCredentials"});
            TakeshiProperties.MandrillCredentials mandrillCredentials = StaticConfig.takeshiProperties.getMandrillCredentials();
            FROM_EMAIL = mandrillCredentials.getFromEmail();
            FROM_NAME = mandrillCredentials.getFromName();
            MANDRILL_API = new MandrillApi(mandrillCredentials.getApiKey());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

