/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.template.Template;
import com.itextpdf.text.DocumentException;
import com.takeshi.util.TakeshiUtil;
import com.takeshi.util.TemplateEngineUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;

public final class PdfUtil {
    private static final Logger log = LoggerFactory.getLogger(PdfUtil.class);
    public static final String FONT_FILES = "fonts";

    private PdfUtil() {
    }

    public static void preview(String templateName, Map<?, ?> map, HttpServletResponse response) {
        try {
            PdfUtil.generatePdf(templateName, map, (OutputStream)response.getOutputStream());
        }
        catch (DocumentException | IOException e) {
            log.error("PdfUtil.preview --> ", e);
        }
    }

    public static void download(String templateName, Map<?, ?> map, HttpServletResponse response) {
        try {
            String fileName = IdUtil.fastSimpleUUID() + ".pdf";
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/pdf;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLUtil.encode((String)fileName));
            PdfUtil.generatePdf(templateName, map, (OutputStream)response.getOutputStream());
        }
        catch (DocumentException | IOException e) {
            log.error("PdfUtil.download --> ", e);
        }
    }

    public static void save(String templateName, Map<?, ?> map, File file) {
        try {
            PdfUtil.generatePdf(templateName, map, FileUtil.getOutputStream((File)file));
        }
        catch (DocumentException | IOException e) {
            log.error("PdfUtil.save --> ", e);
        }
    }

    private static void generatePdf(String templateName, Map<?, ?> bindingMap, OutputStream out) throws DocumentException, IOException {
        Template template = TemplateEngineUtil.engine.getTemplate(templateName + ".html");
        String render = template.render(bindingMap);
        ITextRenderer renderer = new ITextRenderer();
        PdfUtil.addFontDirectory(renderer);
        renderer.setDocumentFromString(render);
        renderer.layout();
        renderer.createPDF(out, true);
        out.close();
    }

    private static void addFontDirectory(ITextRenderer renderer) {
        TakeshiUtil.listFileNames(FONT_FILES).forEach(item -> {
            try {
                renderer.getFontResolver().addFont("fonts/" + item, "Identity-H", false);
            }
            catch (DocumentException | IOException e) {
                log.error("PdfUtil.addFontDirectory --> pdf\u6dfb\u52a0 [" + item + "] \u5b57\u4f53\u6587\u4ef6\u5f02\u5e38", e);
            }
        });
    }
}

