/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TakeshiThreadUtil {
    private static final Logger log = LoggerFactory.getLogger(TakeshiThreadUtil.class);
    private static final long TIMEOUT = 120L;

    private TakeshiThreadUtil() {
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeout) {
        if (pool != null && !pool.isShutdown()) {
            if (pool instanceof ScheduledThreadPoolExecutor) {
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)pool;
                BlockingQueue<Runnable> queue = scheduledThreadPoolExecutor.getQueue();
                queue.removeIf(item -> {
                    if (item instanceof RunnableScheduledFuture) {
                        RunnableScheduledFuture runnableScheduledFuture = (RunnableScheduledFuture)item;
                        long delay = runnableScheduledFuture.getDelay(TimeUnit.SECONDS);
                        return delay > timeout;
                    }
                    return false;
                });
            }
            pool.shutdown();
            try {
                if (!pool.awaitTermination(120L, TimeUnit.SECONDS)) {
                    pool.shutdownNow();
                    if (!pool.awaitTermination(120L, TimeUnit.SECONDS)) {
                        log.info("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                pool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void printException(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            log.error(t.getMessage(), t);
        }
    }
}

