/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.impl.CollectionConverter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.useragent.Platform;
import cn.hutool.http.useragent.UserAgentUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.takeshi.constants.SysCode;
import com.takeshi.exception.TakeshiException;
import com.takeshi.mybatisplus.ColumnResolverWrapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public final class TakeshiUtil {
    private static final Logger log = LoggerFactory.getLogger(TakeshiUtil.class);
    private static final String LOCAL_IP = "0:0:0:0:0:0:0:1";

    private TakeshiUtil() {
    }

    public static <T> String lambdaExtract(SFunction<T, ?> func) {
        return PropertyNamer.methodToProperty((String)LambdaUtils.extract(func).getImplMethodName());
    }

    public static int getDeviceType(HttpServletRequest request) {
        Platform platform = UserAgentUtil.parse((String)request.getHeader(Header.USER_AGENT.getValue())).getPlatform();
        if (platform.isIos()) {
            return 1;
        }
        if (platform.isAndroid()) {
            return 2;
        }
        throw new TakeshiException(SysCode.USERAGENT_ERROR);
    }

    public static String getClientIp(HttpServletRequest request) {
        String clientIp = JakartaServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        if (StrUtil.equals((CharSequence)LOCAL_IP, (CharSequence)clientIp)) {
            return NetUtil.getLocalhostStr();
        }
        return clientIp;
    }

    public static String getRealAddressByIp(String ip) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("ip", ip);
        map.put("json", true);
        return JSONUtil.parseObj((String)HttpUtil.get((String)"https://whois.pconline.com.cn/ipJson.jsp", map)).getStr((Object)"addr");
    }

    public static Map<String, String> getAllParams(HttpServletRequest request) {
        String bodyString;
        Map map = JakartaServletUtil.getParamMap((ServletRequest)request);
        if (!HttpMethod.GET.name().equals(request.getMethod()) && JSONUtil.isTypeJSON((String)(bodyString = JakartaServletUtil.getBody((ServletRequest)request)))) {
            map.putAll((Map)JSONUtil.toBean((String)bodyString, (TypeReference)new TypeReference<Map<String, String>>(){}, (boolean)false));
        }
        return map;
    }

    public static String signParams(HttpServletRequest request, String ... otherParams) {
        Map<String, String> allParams = TakeshiUtil.getAllParams(request);
        if (CollUtil.isEmpty(allParams)) {
            return null;
        }
        return SecureUtil.signParamsSha256(allParams, (String[])otherParams);
    }

    public static <T> List<T> toList(String jsonArray, TypeReference<T> typeReference) {
        return TakeshiUtil.toList(JSONUtil.parseArray((String)jsonArray), typeReference);
    }

    public static <T> List<T> toList(String jsonArray, TypeReference<T> typeReference, Class<?> collectionType) {
        return (List)TakeshiUtil.toList(JSONUtil.parseArray((String)jsonArray), typeReference, collectionType);
    }

    public static <T> List<T> toList(JSONArray jsonArray, TypeReference<T> typeReference) {
        return (List)TakeshiUtil.toList(jsonArray, typeReference, ArrayList.class);
    }

    public static <T> Collection<?> toList(JSONArray jsonArray, TypeReference<T> typeReference, Class<?> collectionType) {
        return new CollectionConverter(collectionType, typeReference).convert((Object)jsonArray, null);
    }

    public static List<String> listFileNames(String path) throws IORuntimeException {
        File[] files;
        if (StrUtil.isBlank((CharSequence)path)) {
            return new ArrayList<String>();
        }
        URL url = ResourceUtil.getResource((String)path);
        if (URLUtil.isJarURL((URL)url)) {
            return ZipUtil.listFileNames((ZipFile)URLUtil.getJarFile((URL)url), (String)path);
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files = FileUtil.ls((String)path)) {
            if (!file.isFile()) continue;
            paths.add(file.getName());
        }
        return paths;
    }

    public static <T> ColumnResolverWrapper<T> columnResolver(Class<T> entityClass) {
        return new ColumnResolverWrapper<T>(entityClass);
    }

    public static <T> String getPropertyName(SFunction<T, ?> func) {
        return PropertyNamer.methodToProperty((String)LambdaUtils.extract(func).getImplMethodName());
    }

    public static <T> String getColumnName(SFunction<T, ?> func) {
        return StrUtil.toUnderlineCase((CharSequence)PropertyNamer.methodToProperty((String)LambdaUtils.extract(func).getImplMethodName()));
    }

    public static boolean isGreater(Long num1, Long num2) {
        Assert.notNull((Object)num1);
        Assert.notNull((Object)num2);
        return num1.compareTo(num2) > 0;
    }

    public static boolean isGreaterOrEqual(Long num1, Long num2) {
        Assert.notNull((Object)num1);
        Assert.notNull((Object)num2);
        return num1.compareTo(num2) >= 0;
    }

    public static boolean isLess(Long num1, Long num2) {
        Assert.notNull((Object)num1);
        Assert.notNull((Object)num2);
        return num1.compareTo(num2) < 0;
    }

    public static boolean isLessOrEqual(Long num1, Long num2) {
        Assert.notNull((Object)num1);
        Assert.notNull((Object)num2);
        return num1.compareTo(num2) <= 0;
    }

    public static boolean equals(Long num1, Long num2) {
        if (ObjUtil.hasNull((Object[])new Object[]{num1, num2})) {
            return false;
        }
        return num1.compareTo(num2) == 0;
    }
}

