/*
 * Decompiled with CFR 0.152.
 */
package com.takeshi.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.TemporalUtil;
import cn.hutool.core.lang.Range;
import cn.hutool.core.util.ObjUtil;
import com.takeshi.constants.TakeshiDatePattern;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public final class ZonedDateTimeUtil {
    private ZonedDateTimeUtil() {
    }

    public static ZonedDateTime now() {
        return ZonedDateTime.now();
    }

    public static ZonedDateTime now(Clock clock) {
        return ZonedDateTime.now(clock);
    }

    public static ZonedDateTime now(ZoneId zoneId) {
        return ZonedDateTime.now(zoneId);
    }

    public static ZonedDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond) {
        return ZonedDateTimeUtil.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, ZoneId.systemDefault());
    }

    public static ZonedDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, TimeZone timeZone) {
        return ZonedDateTimeUtil.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, timeZone.toZoneId());
    }

    public static ZonedDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, ZoneId zoneId) {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, zoneId);
    }

    public static ZonedDateTime ofInstant(Instant instant) {
        return ZonedDateTimeUtil.ofInstant(instant, ZoneId.systemDefault());
    }

    public static ZonedDateTime ofInstant(Instant instant, TimeZone timeZone) {
        return ZonedDateTimeUtil.ofInstant(instant, ((TimeZone)ObjUtil.defaultIfNull((Object)timeZone, TimeZone::getDefault)).toZoneId());
    }

    public static ZonedDateTime ofInstant(Instant instant, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    public static ZonedDateTime ofDate(Date date) {
        if (date instanceof DateTime) {
            return ZonedDateTimeUtil.ofInstant(date.toInstant(), ((DateTime)date).getZoneId());
        }
        return ZonedDateTimeUtil.ofInstant(date.toInstant());
    }

    public static ZonedDateTime of(LocalDateTime localDateTime) {
        return ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
    }

    public static ZonedDateTime of(LocalDateTime localDateTime, TimeZone timeZone) {
        return ZonedDateTime.of(localDateTime, timeZone.toZoneId());
    }

    public static ZonedDateTime of(LocalDateTime localDateTime, ZoneId zoneId) {
        return ZonedDateTime.of(localDateTime, zoneId);
    }

    public static ZonedDateTime of(LocalDate localDate, TimeZone timeZone) {
        return ZonedDateTimeUtil.of(localDate, LocalTime.now(), timeZone.toZoneId());
    }

    public static ZonedDateTime of(LocalDate localDate, ZoneId zoneId) {
        return ZonedDateTimeUtil.of(localDate, LocalTime.now(), zoneId);
    }

    public static ZonedDateTime of(LocalDate localDate, LocalTime localTime, TimeZone timeZone) {
        return ZonedDateTime.of(localDate, localTime, timeZone.toZoneId());
    }

    public static ZonedDateTime of(LocalDate localDate, LocalTime localTime, ZoneId zoneId) {
        return ZonedDateTime.of(localDate, localTime, zoneId);
    }

    public static ZonedDateTime ofLocal(LocalDateTime localDateTime, ZoneOffset preferredOffset) {
        return ZonedDateTime.ofLocal(localDateTime, ZoneId.systemDefault(), preferredOffset);
    }

    public static ZonedDateTime ofLocal(LocalDateTime localDateTime, ZoneId zoneId, ZoneOffset preferredOffset) {
        return ZonedDateTime.ofLocal(localDateTime, zoneId, preferredOffset);
    }

    public static ZonedDateTime ofEpochSecond(long epochSecond) {
        return ZonedDateTimeUtil.ofInstant(Instant.ofEpochSecond(epochSecond));
    }

    public static ZonedDateTime ofEpochSecond(long epochSecond, ZoneId zoneId) {
        return ZonedDateTimeUtil.ofInstant(Instant.ofEpochSecond(epochSecond), zoneId);
    }

    public static ZonedDateTime ofEpochSecond(long epochSecond, TimeZone timeZone) {
        return ZonedDateTimeUtil.ofInstant(Instant.ofEpochSecond(epochSecond), timeZone);
    }

    public static ZonedDateTime ofEpochMilli(long epochMilli) {
        return ZonedDateTimeUtil.ofInstant(Instant.ofEpochMilli(epochMilli));
    }

    public static ZonedDateTime ofEpochMilli(long epochMilli, ZoneId zoneId) {
        return ZonedDateTimeUtil.ofInstant(Instant.ofEpochMilli(epochMilli), zoneId);
    }

    public static ZonedDateTime ofEpochMilli(long epochMilli, TimeZone timeZone) {
        return ZonedDateTimeUtil.ofInstant(Instant.ofEpochMilli(epochMilli), timeZone);
    }

    public static ZonedDateTime ofEpochSecondUtc(long epochSecond) {
        return ZonedDateTimeUtil.ofUtc(Instant.ofEpochSecond(epochSecond));
    }

    public static ZonedDateTime ofEpochMilliUtc(long epochMilli) {
        return ZonedDateTimeUtil.ofUtc(Instant.ofEpochMilli(epochMilli));
    }

    public static ZonedDateTime ofUtc(Instant instant) {
        return ZonedDateTimeUtil.ofInstant(instant, ZoneId.of("UTC"));
    }

    public static ZonedDateTime from(TemporalAccessor temporalAccessor) {
        return ZonedDateTime.from(temporalAccessor);
    }

    public ZonedDateTime parse(CharSequence text) {
        return this.parse(text, null);
    }

    public ZonedDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        if (null == text) {
            return null;
        }
        if (null == formatter) {
            return ZonedDateTime.parse(text);
        }
        return ZonedDateTime.parse(text, formatter);
    }

    public static String formatNormal(ZonedDateTime zonedDateTime) {
        return ZonedDateTimeUtil.format(zonedDateTime, TakeshiDatePattern.NORM_DATETIME_FORMATTER);
    }

    public static String formatNormalDate(ZonedDateTime zonedDateTime) {
        return ZonedDateTimeUtil.format(zonedDateTime, TakeshiDatePattern.NORM_DATE_FORMATTER);
    }

    public static String format(ZonedDateTime zonedDateTime, DateTimeFormatter formatter) {
        if (null == formatter) {
            return zonedDateTime.toString();
        }
        return zonedDateTime.format(formatter);
    }

    public static Duration between(ZonedDateTime startTimeInclude, ZonedDateTime endTimeExclude) {
        return TemporalUtil.between((Temporal)startTimeInclude, (Temporal)endTimeExclude);
    }

    public static long between(ZonedDateTime startTimeInclude, ZonedDateTime endTimeExclude, ChronoUnit unit) {
        return TemporalUtil.between((Temporal)startTimeInclude, (Temporal)endTimeExclude, (ChronoUnit)unit);
    }

    public static List<ZonedDateTime> rangeToList(ZonedDateTime start, ZonedDateTime end, ChronoUnit unit) {
        return CollUtil.newArrayList((Iterable)((Object)ZonedDateTimeUtil.range(start, end, unit)));
    }

    public static List<ZonedDateTime> rangeToList(ZonedDateTime start, ZonedDateTime end, ChronoUnit unit, int step) {
        return CollUtil.newArrayList((Iterable)((Object)new ZonedDateTimeRange(start, end, unit, step)));
    }

    public static ZonedDateTimeRange range(ZonedDateTime start, ZonedDateTime end, ChronoUnit unit) {
        return new ZonedDateTimeRange(start, end, unit);
    }

    public ZonedDateTime beginOfDay(ZonedDateTime zonedDateTime) {
        return zonedDateTime.with(LocalTime.MIN);
    }

    public ZonedDateTime endOfDay(ZonedDateTime zonedDateTime) {
        return this.endOfDay(zonedDateTime, false);
    }

    public ZonedDateTime endOfDay(ZonedDateTime zonedDateTime, boolean truncateMillisecond) {
        if (truncateMillisecond) {
            return zonedDateTime.with(LocalTime.of(23, 59, 59));
        }
        return zonedDateTime.with(LocalTime.MAX);
    }

    public ZonedDateTime beginOfWeek(ZonedDateTime zonedDateTime) {
        return zonedDateTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
    }

    public ZonedDateTime endOfWeek(ZonedDateTime zonedDateTime) {
        return zonedDateTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.SUNDAY));
    }

    public static boolean isWeekend(ZonedDateTime zonedDateTime) {
        DayOfWeek dayOfWeek = zonedDateTime.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == dayOfWeek;
    }

    public static boolean isSameDay(ZonedDateTime date1, ZonedDateTime date2) {
        return date1 != null && date2 != null && ZonedDateTimeUtil.isSameDay(date1.toLocalDate(), date2.toLocalDate());
    }

    public static boolean isSameDay(LocalDate date1, LocalDate date2) {
        return date1 != null && date2 != null && date1.isEqual(date2);
    }

    public static boolean isIn(ZonedDateTime zonedDateTime, ZonedDateTime beginDate, ZonedDateTime endDate) {
        return zonedDateTime.isAfter(beginDate) && zonedDateTime.isBefore(endDate);
    }

    public static LocalDateTime toLocalDateTime(ZonedDateTime zonedDateTime) {
        if (null == zonedDateTime) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    static class ZonedDateTimeRange
    extends Range<ZonedDateTime> {
        private static final long serialVersionUID = 1L;

        public ZonedDateTimeRange(ZonedDateTime start, ZonedDateTime end, ChronoUnit unit) {
            this(start, end, unit, 1);
        }

        public ZonedDateTimeRange(ZonedDateTime start, ZonedDateTime end, ChronoUnit unit, int step) {
            this(start, end, unit, step, true, true);
        }

        public ZonedDateTimeRange(ZonedDateTime start, ZonedDateTime end, ChronoUnit unit, int step, boolean isIncludeStart, boolean isIncludeEnd) {
            super((Object)start, (Object)end, (current, end1, index) -> {
                ZonedDateTime zonedDateTime = start.plus((long)(index + 1) * (long)step, unit);
                if (zonedDateTime.isAfter((ChronoZonedDateTime<?>)end1)) {
                    return null;
                }
                return zonedDateTime;
            }, isIncludeStart, isIncludeEnd);
        }
    }
}

