package life.expert.common.base;

//-------------------------------------------------------------------------------------------------------
//  __    __   __  .___  ___.      ___       __          ___   ____    ____  ___   ____    ____  ___
// |  |  |  | |  | |   \/   |     /   \     |  |        /   \  \   \  /   / /   \  \   \  /   / /   \
// |  |__|  | |  | |  \  /  |    /  ^  \    |  |       /  ^  \  \   \/   / /  ^  \  \   \/   / /  ^  \
// |   __   | |  | |  |\/|  |   /  /_\  \   |  |      /  /_\  \  \_    _/ /  /_\  \  \_    _/ /  /_\  \
// |  |  |  | |  | |  |  |  |  /  _____  \  |  `----./  _____  \   |  |  /  _____  \   |  |  /  _____  \
// |__|  |__| |__| |__|  |__| /__/     \__\ |_______/__/     \__\  |__| /__/     \__\  |__| /__/     \__\
//
//                                            Wilmer Krisp 2019/02/05
//--------------------------------------------------------------------------------------------------------


import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

import lombok.NonNull;//@NOTNULL

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static java.text.MessageFormat.format;           //format string

import java.util.ResourceBundle;

import static com.google.common.base.Preconditions.*;   //checkArgument
//import static life.expert.common.base.Preconditions.*;  //checkCollection
import static org.apache.commons.lang3.Validate.*;      //notEmpty(collection)

import org.apache.commons.lang3.StringUtils;            //isNotBlank

import java.util.function.*;                            //producer supplier

import static java.util.stream.Collectors.*;            //toList streamAPI
import static java.util.function.Predicate.*;           //isEqual streamAPI

import java.util.Optional;

import static reactor.core.publisher.Mono.*;
import static reactor.core.scheduler.Schedulers.*;
import static life.expert.common.async.LogUtils.*;        //logAtInfo
import static life.expert.common.function.NullableUtils.*;//.map(nullableFunction)
import static life.expert.common.function.CheckedUtils.*;// .map(consumerToBoolean)
//import static life.expert.common.function.Patterns.*;    //for-comprehension
import static life.expert.common.base.Objects.*;          //deepCopyOfObject

import static io.vavr.API.*;                              //switch
import static io.vavr.Predicates.*;                       //switch - case
import static io.vavr.Patterns.*;                         //switch - case - success/failure
import static cyclops.control.Trampoline.more;
import static cyclops.control.Trampoline.done;

//import java.util.List;                                  //usual list
//import io.vavr.collection.List;                         //immutable List
//import com.google.common.collect.*;                     //ImmutableList



/**
 * helper methods for the main cycle of the application
 */
@UtilityClass
@Slf4j
public final class ApplicationUtils
	{
	
	/**
	 * some constant
	 */
	public static final String FATAL_MESSAGE = "The program has encountered a problem and should close. We apologize for any inconvenience.";
	
	/**
	 * general info:
	 * handler for unprocessed situations
	 *
	 * side effects:
	 * - print and log messages
	 * - close JVM
	 *
	 * <pre>{@code
	 *           try{
	 *                   //some code
	 *           } catch (TheCheckedException e) {
	 *           e.printStackTrace(); // Oh well, we lose.
	 *           fatalError();
	 *           }
	 * }**</pre>
	 *
	 * @param throwable
	 * 	the throwable
	 */
	public static void fatalError( Throwable throwable )
		{
		throwable.printStackTrace();
		System.err.println( FATAL_MESSAGE );
		logger_.error( FATAL_MESSAGE , throwable );
		System.exit( 1 );
		}
		
	}
