/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.async;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import life.expert.common.async.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LogUtils {
    public static final Logger logger_ = LoggerFactory.getLogger(LogUtils.class);

    public static void log(String format, Object ... arguments) {
        logger_.info(format, arguments);
    }

    public static void logAtWarning(String format, Object ... arguments) {
        logger_.warn(format, arguments);
    }

    public static void logAtError(String format, Object ... arguments) {
        logger_.error(format, arguments);
    }

    public static void logAtDebug(String format, Object ... arguments) {
        logger_.debug(format, arguments);
    }

    public static <E> Consumer<E> logAtInfoConsumer(String message) {
        return o -> LogUtils.log("{}   {} in({})", Thread.currentThread(), message == null ? "logAtInfoConsumer" : message, o);
    }

    public static <E> Consumer<E> logAtInfoConsumer() {
        return LogUtils.logAtInfoConsumer(null);
    }

    public static <E, F> BiConsumer<E, F> logAtInfoBiConsumer(String message) {
        return (a, b) -> LogUtils.log("{}   {} in({}) in({})", Thread.currentThread(), message == null ? "logAtInfoBiConsumer" : message, a, b);
    }

    public static <E, F> BiConsumer<E, F> logAtInfoBiConsumer() {
        return LogUtils.logAtInfoBiConsumer(null);
    }

    public static <T, R> Function<T, R> logAtInfoFunction(String message, R returnObject) {
        return o -> {
            LogUtils.log("{}   {} in({}) out({})", Thread.currentThread(), message == null ? "logAtInfoFunction" : message, o, returnObject);
            return returnObject;
        };
    }

    public static <T, R> Function<T, R> logAtInfoFunction(R returnObject) {
        return LogUtils.logAtInfoFunction(null, returnObject);
    }

    public static <T, U, R> BiFunction<T, U, R> logAtInfoBiFunction(String message, R returnObject) {
        return (a, b) -> {
            LogUtils.log("{}   {} in({}) in({}) out({})", Thread.currentThread(), message == null ? "logAtInfoBiFunction" : message, a, b, returnObject);
            return returnObject;
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtInfoBiFunction(R returnObject) {
        return LogUtils.logAtInfoBiFunction(null, returnObject);
    }

    public static <E> UnaryOperator<E> logAtInfoUnaryOperator(String message) {
        return o -> {
            LogUtils.log("{}   {} in({})", Thread.currentThread(), message == null ? "logAtInfoUnaryOperator" : message, o);
            return o;
        };
    }

    public static <E> UnaryOperator<E> logAtInfoUnaryOperator() {
        return LogUtils.logAtInfoUnaryOperator(null);
    }

    public static <E> Supplier<E> logAtInfoSupplier(String message, E returnObject) {
        return () -> {
            LogUtils.log("{}   {} out({})", Thread.currentThread(), message == null ? "logAtInfoSupplier" : message, returnObject);
            return returnObject;
        };
    }

    public static <E> Supplier<E> logAtInfoSupplier(E returnObject) {
        return LogUtils.logAtInfoSupplier(null, returnObject);
    }

    public static <E> Runnable logAtInfoRunnable(String message) {
        return () -> LogUtils.log("{}   {}", Thread.currentThread(), message == null ? "logAtInfoRunnable" : message);
    }

    public static <E> Runnable logAtInfoRunnable() {
        return LogUtils.logAtInfoRunnable(null);
    }

    public static void logAtInfo(String message) {
        LogUtils.log("{}   {}", Thread.currentThread(), message == null || message.isBlank() ? "logAtInfo" : message);
    }

    public static void logAtInfo() {
        LogUtils.logAtInfo("");
    }

    public static <E> Consumer<E> logAtInfoConsumerWrapper(Consumer<E> consumer) {
        return o -> {
            LogUtils.log("{}   {} in({})", Thread.currentThread(), "logAtInfoConsumerWrapper", o);
            consumer.accept(o);
        };
    }

    public static <E, F> BiConsumer<E, F> logAtInfoBiConsumerWrapper(BiConsumer<E, F> consumer) {
        return (a, b) -> {
            LogUtils.log("{}   {} in({}) in({})", Thread.currentThread(), "logAtInfoBiConsumerWrapper", a, b);
            consumer.accept(a, b);
        };
    }

    public static <T, R> Function<T, R> logAtInfoFunctionWrapper(Function<T, R> function) {
        return o -> {
            LogUtils.log("{}   {} in({})", Thread.currentThread(), "logAtInfoFunctionWrapper", o);
            return function.apply(o);
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtInfoBiFunctionWrapper(BiFunction<T, U, R> function) {
        return (a, b) -> {
            LogUtils.log("{}   {} in({}) in({})", Thread.currentThread(), "logAtInfoBiFunctionWrapper", a, b);
            return function.apply(a, b);
        };
    }

    public static <E> Supplier<E> logAtInfoSupplierWrapper(Supplier<E> supplier) {
        return () -> {
            LogUtils.log("{}   {}", Thread.currentThread(), "logAtInfoSupplierWrapper");
            return supplier.get();
        };
    }

    public static <E> Runnable logAtInfoRunnableWrapper(Runnable runnable) {
        return () -> {
            LogUtils.log("{}   {}", Thread.currentThread(), "logAtInfoRunnableWrapper");
            runnable.run();
        };
    }

    public static <E> Consumer<E> logAtErrorConsumer(String message) {
        return o -> LogUtils.logAtError("{}   {} in({})", Thread.currentThread(), message == null ? "logAtErrorConsumer" : message, o);
    }

    public static <E> Consumer<E> logAtErrorConsumer() {
        return LogUtils.logAtErrorConsumer(null);
    }

    public static <E, F> BiConsumer<E, F> logAtErrorBiConsumer(String message) {
        return (a, b) -> LogUtils.logAtError("{}   {} in({}) in({})", Thread.currentThread(), message == null ? "logAtErrorBiConsumer" : message, a, b);
    }

    public static <E, F> BiConsumer<E, F> logAtErrorBiConsumer() {
        return LogUtils.logAtErrorBiConsumer(null);
    }

    public static <T, R> Function<T, R> logAtErrorFunction(String message, R returnObject) {
        return o -> {
            LogUtils.logAtError("{}   {} in({}) out({})", Thread.currentThread(), message == null ? "logAtErrorFunction" : message, o, returnObject);
            return returnObject;
        };
    }

    public static <T, R> Function<T, R> logAtErrorFunction(R returnObject) {
        return LogUtils.logAtErrorFunction(null, returnObject);
    }

    public static <T, U, R> BiFunction<T, U, R> logAtErrorBiFunction(String message, R returnObject) {
        return (a, b) -> {
            LogUtils.logAtError("{}   {} in({}) in({}) out({})", Thread.currentThread(), message == null ? "logAtErrorBiFunction" : message, a, b, returnObject);
            return returnObject;
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtErrorBiFunction(R returnObject) {
        return LogUtils.logAtErrorBiFunction(null, returnObject);
    }

    public static <E> UnaryOperator<E> logAtErrorUnaryOperator(String message) {
        return o -> {
            LogUtils.logAtError("{}   {} in({})", Thread.currentThread(), message == null ? "logAtErrorUnaryOperator" : message, o);
            return o;
        };
    }

    public static <E> UnaryOperator<E> logAtErrorUnaryOperator() {
        return LogUtils.logAtErrorUnaryOperator(null);
    }

    public static <E> Supplier<E> logAtErrorSupplier(String message, E returnObject) {
        return () -> {
            LogUtils.logAtError("{}   {} out({})", Thread.currentThread(), message == null ? "logAtErrorSupplier" : message, returnObject);
            return returnObject;
        };
    }

    public static <E> Supplier<E> logAtErrorSupplier(E returnObject) {
        return LogUtils.logAtErrorSupplier(null, returnObject);
    }

    public static <E> Runnable logAtErrorRunnable(String message) {
        return () -> LogUtils.logAtError("{}   {}", Thread.currentThread(), message == null ? "logAtErrorRunnable" : message);
    }

    public static <E> Runnable logAtErrorRunnable() {
        return LogUtils.logAtErrorRunnable(null);
    }

    public static void logAtError(String message) {
        LogUtils.logAtError("{}   {}", Thread.currentThread(), message == null || message.isBlank() ? "logAtError" : message);
    }

    public static void logAtError() {
        LogUtils.logAtError("");
    }

    public static <E> Consumer<E> logAtErrorConsumerWrapper(Consumer<E> consumer) {
        return o -> {
            LogUtils.logAtError("{}   {} in({})", Thread.currentThread(), "logAtErrorConsumerWrapper", o);
            consumer.accept(o);
        };
    }

    public static <E, F> BiConsumer<E, F> logAtErrorBiConsumerWrapper(BiConsumer<E, F> consumer) {
        return (a, b) -> {
            LogUtils.logAtError("{}   {} in({}) in({})", Thread.currentThread(), "logAtErrorBiConsumerWrapper", a, b);
            consumer.accept(a, b);
        };
    }

    public static <T, R> Function<T, R> logAtErrorFunctionWrapper(Function<T, R> function) {
        return o -> {
            LogUtils.logAtError("{}   {} in({})", Thread.currentThread(), "logAtErrorFunctionWrapper", o);
            return function.apply(o);
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtErrorBiFunctionWrapper(BiFunction<T, U, R> function) {
        return (a, b) -> {
            LogUtils.logAtError("{}   {} in({}) in({})", Thread.currentThread(), "logAtErrorBiFunctionWrapper", a, b);
            return function.apply(a, b);
        };
    }

    public static <E> Supplier<E> logAtErrorSupplierWrapper(Supplier<E> supplier) {
        return () -> {
            LogUtils.logAtError("{}   {}", Thread.currentThread(), "logAtErrorSupplierWrapper");
            return supplier.get();
        };
    }

    public static <E> Runnable logAtErrorRunnableWrapper(Runnable runnable) {
        return () -> {
            LogUtils.logAtError("{}   {}", Thread.currentThread(), "logAtErrorRunnableWrapper");
            runnable.run();
        };
    }

    public static <E> Consumer<E> logAtWarningConsumer(String message) {
        return o -> LogUtils.logAtWarning("{}   {} in({})", Thread.currentThread(), message == null ? "logAtWarningConsumer" : message, o);
    }

    public static <E> Consumer<E> logAtWarningConsumer() {
        return LogUtils.logAtWarningConsumer(null);
    }

    public static <E, F> BiConsumer<E, F> logAtWarningBiConsumer(String message) {
        return (a, b) -> LogUtils.logAtWarning("{}   {} in({}) in({})", Thread.currentThread(), message == null ? "logAtWarningBiConsumer" : message, a, b);
    }

    public static <E, F> BiConsumer<E, F> logAtWarningBiConsumer() {
        return LogUtils.logAtWarningBiConsumer(null);
    }

    public static <T, R> Function<T, R> logAtWarningFunction(String message, R returnObject) {
        return o -> {
            LogUtils.logAtWarning("{}   {} in({}) out({})", Thread.currentThread(), message == null ? "logAtWarningFunction" : message, o, returnObject);
            return returnObject;
        };
    }

    public static <T, R> Function<T, R> logAtWarningFunction(R returnObject) {
        return LogUtils.logAtWarningFunction(null, returnObject);
    }

    public static <T, U, R> BiFunction<T, U, R> logAtWarningBiFunction(String message, R returnObject) {
        return (a, b) -> {
            LogUtils.logAtWarning("{}   {} in({}) in({}) out({})", Thread.currentThread(), message == null ? "logAtWarningBiFunction" : message, a, b, returnObject);
            return returnObject;
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtWarningBiFunction(R returnObject) {
        return LogUtils.logAtWarningBiFunction(null, returnObject);
    }

    public static <E> UnaryOperator<E> logAtWarningUnaryOperator(String message) {
        return o -> {
            LogUtils.logAtWarning("{}   {} in({})", Thread.currentThread(), message == null ? "logAtWarningUnaryOperator" : message, o);
            return o;
        };
    }

    public static <E> UnaryOperator<E> logAtWarningUnaryOperator() {
        return LogUtils.logAtWarningUnaryOperator(null);
    }

    public static <E> Supplier<E> logAtWarningSupplier(String message, E returnObject) {
        return () -> {
            LogUtils.logAtWarning("{}   {} out({})", Thread.currentThread(), message == null ? "logAtWarningSupplier" : message, returnObject);
            return returnObject;
        };
    }

    public static <E> Supplier<E> logAtWarningSupplier(E returnObject) {
        return LogUtils.logAtWarningSupplier(null, returnObject);
    }

    public static <E> Runnable logAtWarningRunnable(String message) {
        return () -> LogUtils.logAtWarning("{}   {}", Thread.currentThread(), message == null ? "logAtWarningRunnable" : message);
    }

    public static <E> Runnable logAtWarningRunnable() {
        return LogUtils.logAtWarningRunnable(null);
    }

    public static void logAtWarning(String message) {
        LogUtils.logAtWarning("{}   {}", Thread.currentThread(), message == null || message.isBlank() ? "logAtWarning" : message);
    }

    public static void logAtWarning() {
        LogUtils.logAtWarning("");
    }

    public static <E> Consumer<E> logAtWarningConsumerWrapper(Consumer<E> consumer) {
        return o -> {
            LogUtils.logAtWarning("{}   {} in({})", Thread.currentThread(), "logAtWarningConsumerWrapper", o);
            consumer.accept(o);
        };
    }

    public static <E, F> BiConsumer<E, F> logAtWarningBiConsumerWrapper(BiConsumer<E, F> consumer) {
        return (a, b) -> {
            LogUtils.logAtWarning("{}   {} in({}) in({})", Thread.currentThread(), "logAtWarningBiConsumerWrapper", a, b);
            consumer.accept(a, b);
        };
    }

    public static <T, R> Function<T, R> logAtWarningFunctionWrapper(Function<T, R> function) {
        return o -> {
            LogUtils.logAtWarning("{}   {} in({})", Thread.currentThread(), "logAtWarningFunctionWrapper", o);
            return function.apply(o);
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtWarningBiFunctionWrapper(BiFunction<T, U, R> function) {
        return (a, b) -> {
            LogUtils.logAtWarning("{}   {} in({}) in({})", Thread.currentThread(), "logAtWarningBiFunctionWrapper", a, b);
            return function.apply(a, b);
        };
    }

    public static <E> Supplier<E> logAtWarningSupplierWrapper(Supplier<E> supplier) {
        return () -> {
            LogUtils.logAtWarning("{}   {}", Thread.currentThread(), "logAtWarningSupplierWrapper");
            return supplier.get();
        };
    }

    public static <E> Runnable logAtWarningRunnableWrapper(Runnable runnable) {
        return () -> {
            LogUtils.logAtWarning("{}   {}", Thread.currentThread(), "logAtWarningRunnableWrapper");
            runnable.run();
        };
    }

    public static <E> Consumer<E> logAtDebugConsumer(String message) {
        return o -> LogUtils.logAtDebug("{}   {} in({})", Thread.currentThread(), message == null ? "logAtDebugConsumer" : message, o);
    }

    public static <E> Consumer<E> logAtDebugConsumer() {
        return LogUtils.logAtDebugConsumer(null);
    }

    public static <E, F> BiConsumer<E, F> logAtDebugBiConsumer(String message) {
        return (a, b) -> LogUtils.logAtDebug("{}   {} in({}) in({})", Thread.currentThread(), message == null ? "logAtDebugBiConsumer" : message, a, b);
    }

    public static <E, F> BiConsumer<E, F> logAtDebugBiConsumer() {
        return LogUtils.logAtDebugBiConsumer(null);
    }

    public static <T, R> Function<T, R> logAtDebugFunction(String message, R returnObject) {
        return o -> {
            LogUtils.logAtDebug("{}   {} in({}) out({})", Thread.currentThread(), message == null ? "logAtDebugFunction" : message, o, returnObject);
            return returnObject;
        };
    }

    public static <T, R> Function<T, R> logAtDebugFunction(R returnObject) {
        return LogUtils.logAtDebugFunction(null, returnObject);
    }

    public static <T, U, R> BiFunction<T, U, R> logAtDebugBiFunction(String message, R returnObject) {
        return (a, b) -> {
            LogUtils.logAtDebug("{}   {} in({}) in({}) out({})", Thread.currentThread(), message == null ? "logAtDebugBiFunction" : message, a, b, returnObject);
            return returnObject;
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtDebugBiFunction(R returnObject) {
        return LogUtils.logAtDebugBiFunction(null, returnObject);
    }

    public static <E> UnaryOperator<E> logAtDebugUnaryOperator(String message) {
        return o -> {
            LogUtils.logAtDebug("{}   {} in({})", Thread.currentThread(), message == null ? "logAtDebugUnaryOperator" : message, o);
            return o;
        };
    }

    public static <E> UnaryOperator<E> logAtDebugUnaryOperator() {
        return LogUtils.logAtDebugUnaryOperator(null);
    }

    public static <E> Supplier<E> logAtDebugSupplier(String message, E returnObject) {
        return () -> {
            LogUtils.logAtDebug("{}   {} out({})", Thread.currentThread(), message == null ? "logAtDebugSupplier" : message, returnObject);
            return returnObject;
        };
    }

    public static <E> Supplier<E> logAtDebugSupplier(E returnObject) {
        return LogUtils.logAtDebugSupplier(null, returnObject);
    }

    public static <E> Runnable logAtDebugRunnable(String message) {
        return () -> LogUtils.logAtDebug("{}   {}", Thread.currentThread(), message == null ? "logAtDebugRunnable" : message);
    }

    public static <E> Runnable logAtDebugRunnable() {
        return LogUtils.logAtDebugRunnable(null);
    }

    public static void logAtDebug(String message) {
        LogUtils.logAtDebug("{}   {}", Thread.currentThread(), message == null || message.isBlank() ? "logAtDebug" : message);
    }

    public static void logAtDebug() {
        LogUtils.logAtDebug("");
    }

    public static <E> Consumer<E> logAtDebugConsumerWrapper(Consumer<E> consumer) {
        return o -> {
            LogUtils.logAtDebug("{}   {} in({})", Thread.currentThread(), "logAtDebugConsumerWrapper", o);
            consumer.accept(o);
        };
    }

    public static <E, F> BiConsumer<E, F> logAtDebugBiConsumerWrapper(BiConsumer<E, F> consumer) {
        return (a, b) -> {
            LogUtils.logAtDebug("{}   {} in({}) in({})", Thread.currentThread(), "logAtDebugBiConsumerWrapper", a, b);
            consumer.accept(a, b);
        };
    }

    public static <T, R> Function<T, R> logAtDebugFunctionWrapper(Function<T, R> function) {
        return o -> {
            LogUtils.logAtDebug("{}   {} in({})", Thread.currentThread(), "logAtDebugFunctionWrapper", o);
            return function.apply(o);
        };
    }

    public static <T, U, R> BiFunction<T, U, R> logAtDebugBiFunctionWrapper(BiFunction<T, U, R> function) {
        return (a, b) -> {
            LogUtils.logAtDebug("{}   {} in({}) in({})", Thread.currentThread(), "logAtDebugBiFunctionWrapper", a, b);
            return function.apply(a, b);
        };
    }

    public static <E> Supplier<E> logAtDebugSupplierWrapper(Supplier<E> supplier) {
        return () -> {
            LogUtils.logAtDebug("{}   {}", Thread.currentThread(), "logAtDebugSupplierWrapper");
            return supplier.get();
        };
    }

    public static <E> Runnable logAtDebugRunnableWrapper(Runnable runnable) {
        return () -> {
            LogUtils.logAtDebug("{}   {}", Thread.currentThread(), "logAtDebugRunnableWrapper");
            runnable.run();
        };
    }

    public static <E> UnaryOperator<E> delayUnaryOperator(String message, long second) {
        return x -> {
            LogUtils.log("{}   {} in({}) delay({})", Thread.currentThread(), message == null ? "delayUnaryOperator" : message, x, second);
            ThreadUtils.delay(second);
            return x;
        };
    }

    public static <E> UnaryOperator<E> delayUnaryOperator(long second) {
        return LogUtils.delayUnaryOperator(null, second);
    }

    public static <T, R> Function<T, R> delayFunction(String message, R returnObject, long second) {
        return x -> {
            LogUtils.log("{}   {} in({}) out({}) delay({})", Thread.currentThread(), message == null ? "delayFunction" : message, x, returnObject, second);
            ThreadUtils.delay(second);
            return returnObject;
        };
    }

    public static <T, R> Function<T, R> delayFunction(R returnObject, long second) {
        return LogUtils.delayFunction(null, returnObject, second);
    }

    public static <T, U, R> BiFunction<T, U, R> delayBiFunction(String message, R returnObject, long second) {
        return (a, b) -> {
            LogUtils.log("{}   {} in({}) in({}) out({}) delay({})", Thread.currentThread(), message == null ? "delayFunction" : message, a, b, returnObject, second);
            ThreadUtils.delay(second);
            return returnObject;
        };
    }

    public static <T, U, R> BiFunction<T, U, R> delayBiFunction(R returnObject, long second) {
        return LogUtils.delayBiFunction(null, returnObject, second);
    }

    public static <E> Consumer<E> delayConsumer(String message, long second) {
        return x -> {
            LogUtils.log("{}   {} in({}) delay({})", Thread.currentThread(), message == null ? "delayConsumer" : message, x, second);
            ThreadUtils.delay(second);
        };
    }

    public static <E> Consumer<E> delayConsumer(long second) {
        return LogUtils.delayConsumer(null, second);
    }

    public static <E, F> BiConsumer<E, F> delayBiConsumer(String message, long second) {
        return (a, b) -> {
            LogUtils.log("{}   {} in({}) in({}) delay({})", Thread.currentThread(), message == null ? "delayConsumer" : message, a, b, second);
            ThreadUtils.delay(second);
        };
    }

    public static <E, F> BiConsumer<E, F> delayBiConsumer(long second) {
        return LogUtils.delayBiConsumer(null, second);
    }

    public static <E> Supplier<E> delaySupplier(String message, E passThought, long second) {
        return () -> {
            LogUtils.log("{}   {} out({}) delay({})", Thread.currentThread(), message == null ? "delaySupplier" : message, passThought, second);
            ThreadUtils.delay(second);
            return passThought;
        };
    }

    public static <E> Supplier<E> delaySupplier(E passThought, long second) {
        return LogUtils.delaySupplier(null, passThought, second);
    }

    public static <E> Runnable delayRunnable(String message, long second) {
        return () -> {
            LogUtils.log("{}   {} delay({})", Thread.currentThread(), message == null ? "delayRunnable" : message, second);
            ThreadUtils.delay(second);
        };
    }

    public static <E> Runnable delayRunnable(long second) {
        return LogUtils.delayRunnable(null, second);
    }

    public static <E> Supplier<E> delaySupplierWithError(String message, E passThought, E errValueForCompare, long second) {
        return () -> {
            LogUtils.log("{}   {} out({}) delay({})", Thread.currentThread(), message == null ? "delaySupplierWithError" : message, passThought, second);
            ThreadUtils.delay(second);
            if (passThought.equals(errValueForCompare)) {
                throw new IllegalArgumentException("delaySupplierWithError");
            }
            return passThought;
        };
    }

    public static <E> UnaryOperator<E> delayUnaryOperatorWithError(String message, E errValueForCompare, long second) {
        return x -> {
            LogUtils.log("{}   {} in({}) delay({})", Thread.currentThread(), message == null ? "delayUnaryOperatorWithError" : message, x, second);
            ThreadUtils.delay(second);
            if (x.equals(errValueForCompare)) {
                throw new IllegalArgumentException("delaySupplierWithError");
            }
            return x;
        };
    }

    public static <T, R> Function<T, R> delayFunctionWithError(String message, T errValueForCompare, R returnObject, long second) {
        return x -> {
            LogUtils.log("{}   {} in({}) out({}) delay({})", Thread.currentThread(), message == null ? "delayFunctionWithError" : message, x, returnObject, second);
            ThreadUtils.delay(second);
            if (x.equals(errValueForCompare)) {
                throw new IllegalArgumentException("delayFunctionWithError");
            }
            return returnObject;
        };
    }

    public static <E> E defaultDelayUnaryOperator(E object) {
        LogUtils.log("{}   {} in({}) out({}) delay({})", Thread.currentThread(), "defaultDelayUnaryOperator", object, object, 1L);
        ThreadUtils.delay(1L);
        return object;
    }

    public static <E> void defaultDelayConsumer(E object) {
        LogUtils.log("{}   {} in({}) delay({})", Thread.currentThread(), "defaultDelayConsumer", object, 1L);
        ThreadUtils.delay(1L);
    }

    public static <E, F> void defaultDelayBiConsumer(E left, F right) {
        LogUtils.log("{}   {} in({}) in({}) delay({})", Thread.currentThread(), "defaultDelayBiConsumer", left, right, 1L);
        ThreadUtils.delay(1L);
    }

    public static <E> void defaultDelayRunnable() {
        LogUtils.log("{}   {} delay({})", Thread.currentThread(), "defaultDelayRunnable", 1L);
        ThreadUtils.delay(1L);
    }
}

