/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.async;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public interface PrintUtils {
    public static void print(String format, Object ... arguments) {
        Optional<FormattingTuple> tuple = Optional.ofNullable(MessageFormatter.arrayFormat((String)format, (Object[])arguments));
        tuple.map(FormattingTuple::getMessage).ifPresent(System.out::println);
        tuple.map(FormattingTuple::getThrowable).ifPresent(err -> err.printStackTrace(System.out));
    }

    public static <E> Consumer<E> printConsumer(String message) {
        return o -> PrintUtils.print("{}   {} in({})", Thread.currentThread(), message == null ? "printConsumer" : message, o);
    }

    public static <E> Consumer<E> printConsumer() {
        return PrintUtils.printConsumer(null);
    }

    public static <E, F> BiConsumer<E, F> printBiConsumer(String message) {
        return (a, b) -> PrintUtils.print("{}   {} in({}) in({})", Thread.currentThread(), message == null ? "printBiConsumer" : message, a, b);
    }

    public static <E, F> BiConsumer<E, F> printBiConsumer() {
        return PrintUtils.printBiConsumer(null);
    }

    public static <T, R> Function<T, R> printFunction(String message, R returnObject) {
        return o -> {
            PrintUtils.print("{}   {} in({}) out({})", Thread.currentThread(), message == null ? "printFunction" : message, o, returnObject);
            return returnObject;
        };
    }

    public static <T, R> Function<T, R> printFunction(R returnObject) {
        return PrintUtils.printFunction(null, returnObject);
    }

    public static <T, U, R> BiFunction<T, U, R> printBiFunction(String message, R returnObject) {
        return (a, b) -> {
            PrintUtils.print("{}   {} in({}) in({}) out({})", Thread.currentThread(), message == null ? "printBiFunction" : message, a, b, returnObject);
            return returnObject;
        };
    }

    public static <T, U, R> BiFunction<T, U, R> printBiFunction(R returnObject) {
        return PrintUtils.printBiFunction(null, returnObject);
    }

    public static <E> UnaryOperator<E> printUnaryOperator(String message) {
        return o -> {
            PrintUtils.print("{}   {} in({})", Thread.currentThread(), message == null ? "printUnaryOperator" : message, o);
            return o;
        };
    }

    public static <E> UnaryOperator<E> printUnaryOperator() {
        return PrintUtils.printUnaryOperator(null);
    }

    public static <E> Supplier<E> printSupplier(String message, E returnObject) {
        return () -> {
            PrintUtils.print("{}   {} out({})", Thread.currentThread(), message == null ? "printSupplier" : message, returnObject);
            return returnObject;
        };
    }

    public static <E> Supplier<E> printSupplier(E returnObject) {
        return PrintUtils.printSupplier(null, returnObject);
    }

    public static <E> Runnable printRunnable(String message) {
        return () -> PrintUtils.print("{}   {}", Thread.currentThread(), message == null ? "printRunnable" : message);
    }

    public static <E> Runnable printRunnable() {
        return PrintUtils.printRunnable(null);
    }

    public static void print(String message) {
        PrintUtils.print("{}   {}", Thread.currentThread(), message == null || message.isBlank() ? "print" : message);
    }

    public static void print() {
        PrintUtils.print("");
    }

    public static <E> Consumer<E> printConsumerWrapper(Consumer<E> consumer) {
        return o -> {
            PrintUtils.print("{}   {} in({})", Thread.currentThread(), "printConsumerWrapper", o);
            consumer.accept(o);
        };
    }

    public static <E, F> BiConsumer<E, F> printBiConsumerWrapper(BiConsumer<E, F> consumer) {
        return (a, b) -> {
            PrintUtils.print("{}   {} in({}) in({})", Thread.currentThread(), "printBiConsumerWrapper", a, b);
            consumer.accept(a, b);
        };
    }

    public static <T, R> Function<T, R> printFunctionWrapper(Function<T, R> function) {
        return o -> {
            PrintUtils.print("{}   {} in({})", Thread.currentThread(), "printFunctionWrapper", o);
            return function.apply(o);
        };
    }

    public static <T, U, R> BiFunction<T, U, R> printBiFunctionWrapper(BiFunction<T, U, R> function) {
        return (a, b) -> {
            PrintUtils.print("{}   {} in({}) in({})", Thread.currentThread(), "printBiFunctionWrapper", a, b);
            return function.apply(a, b);
        };
    }

    public static <E> Supplier<E> printSupplierWrapper(Supplier<E> supplier) {
        return () -> {
            PrintUtils.print("{}   {}", Thread.currentThread(), "printSupplierWrapper");
            return supplier.get();
        };
    }

    public static <E> Runnable printRunnableWrapper(Runnable runnable) {
        return () -> {
            PrintUtils.print("{}   {}", Thread.currentThread(), "printRunnableWrapper");
            runnable.run();
        };
    }
}

