/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import life.expert.common.async.ConsumerInterrupted;
import life.expert.common.async.RunnableInterrupted;
import life.expert.common.async.SupplierInterrupted;

public final class ThreadUtils {
    private static final int WAIT_TIME_RATIO_FOR_WAITING_TASKS = 100;

    private ThreadUtils() {
        throw new UnsupportedOperationException("Dont use this PRIVATE constructor.Please use constructor with parameters.");
    }

    public static void delay(long second) {
        ThreadUtils.interruptedWrapper(() -> Thread.sleep(1000L * second));
    }

    public static Executor executorDaemon(String name, int size, int waitTimeRatio) {
        ThreadFactory thread_factory = new ThreadFactoryBuilder().setNameFormat((String)(name == null ? "pool%d" : name + "%d")).setDaemon(true).build();
        int thr_num = Runtime.getRuntime().availableProcessors() * (waitTimeRatio == 0 ? 1 : waitTimeRatio);
        return Executors.newFixedThreadPool(Math.min(size, thr_num), thread_factory);
    }

    public static Executor executorDaemon(int size, int waitTimeRatio) {
        return ThreadUtils.executorDaemon(null, size, waitTimeRatio);
    }

    public static Executor executorForWaitingTasks(int size) {
        return ThreadUtils.executorDaemon(size, 100);
    }

    public static Executor executorCustom(String name, int size) {
        ThreadFactory thread_factory = new ThreadFactoryBuilder().setNameFormat((String)(name == null ? "pool%d" : name + "%d")).setDaemon(true).build();
        return new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), thread_factory);
    }

    public static void interruptedWrapper(RunnableInterrupted operation) {
        if (operation == null) {
            throw new NullPointerException();
        }
        try {
            operation.run();
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <E> E interruptedWrapper(SupplierInterrupted<E> operation) {
        if (operation == null) {
            throw new NullPointerException();
        }
        try {
            return operation.get();
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <E> Optional<E> interruptedOptional(SupplierInterrupted<E> operation) {
        if (operation == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(operation.get());
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return Optional.empty();
        }
    }

    public static <E> void interruptedWrapper(E input, ConsumerInterrupted<E> operation) {
        if (operation == null) {
            throw new NullPointerException();
        }
        try {
            operation.accept(input);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
    }
}

