/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.async.memoizer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;

public class ConcurrentTrampoliningMemoizer<T, R> {
    private static final Executor TRAMPOLINE_ = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
    private final ConcurrentMap<T, CompletableFuture<R>> memo_;

    public ConcurrentTrampoliningMemoizer(ConcurrentMap<T, CompletableFuture<R>> cache) {
        this.memo_ = cache;
    }

    public Function<T, CompletableFuture<R>> memoize(Function<T, CompletableFuture<R>> f) {
        return t -> {
            CompletableFuture compute;
            CompletionStage r = (CompletableFuture)this.memo_.get(t);
            if (r == null && (r = this.memo_.putIfAbsent(t, compute = new CompletableFuture())) == null) {
                r = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (CompletableFuture)f.apply(t), TRAMPOLINE_).thenCompose(Function.identity())).thenCompose(x -> {
                    compute.complete(x);
                    return compute;
                });
            }
            return r;
        };
    }
}

