/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.async.memoizer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import life.expert.common.async.memoizer.ConcurrentTrampoliningMemoizer;

public interface MemoizedConcurrently {
    public static <T, R> Function<T, CompletableFuture<R>> of(Function<T, CompletableFuture<R>> function) {
        if (function == null) {
            throw new IllegalArgumentException("Lambda-function must not be null");
        }
        if (function instanceof MemoizedConcurrently) {
            return function;
        }
        ConcurrentHashMap cache = new ConcurrentHashMap();
        ConcurrentTrampoliningMemoizer memoizer = new ConcurrentTrampoliningMemoizer(cache);
        Function memoized = memoizer.memoize(function);
        return memoized::apply;
    }
}

