/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.base;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Preconditions {
    private static final int DEBUG_WINDOW_NUM_COL = 80;
    private static final String MESSAGE_WRONG_NUMBER = "Number argument should'not be less than zero.";
    private static final String MESSAGE_WRONG_STRING_NULL = "String argument should'not be null.";
    private static final String MESSAGE_WRONG_STRING_EMPTY = "String argument should'not \"\" be empty (not null but length=0).";
    private static final String MESSAGE_WRONG_STRING_BLANK = "String argument should'not be \" \" blank (not empty but some spaces here).";
    private static final String MESSAGE_WRONG_COLLECTION = "%d wrong elements in collection \n Indexes of wrong elements: %s \n Collection: %s ";
    private static final String MESSAGE_WRONG_COLLECTION_NULL = "Argument(collection) should'not be null.";
    private static final String MESSAGE_WRONG_COLLECTION_EMPTY = "Argument(Collection) should'not be empty (not null but length=0):";
    private static final String MESSAGE_WRONG_MAP = "%d wrong entries in map \n Keys of wrong entries: %s \n Map: %s ";
    private static final String MESSAGE_WRONG_MAP_NULL = "Argument(map) should'not be null.";
    private static final String MESSAGE_WRONG_MAP_EMPTY = "Argument(map) should'not be empty (not null but length=0):";
    public static final LongPredicate goodLong = l -> l > 0L;
    public static final LongPredicate badLong = l -> l <= 0L;
    public static final Predicate<String> goodString = s -> s != null && !s.isEmpty() && !s.isBlank();
    public static final Predicate<String> badString = s -> s == null || s.isEmpty() || s.isBlank();
    public static final Predicate<? extends Collection<?>> goodCollection = c -> c != null && !c.isEmpty();
    public static final Predicate<? extends Collection<?>> badCollection = c -> c == null || c.isEmpty();
    public static final Predicate<? extends Map<?, ?>> goodMap = m -> m != null && !m.isEmpty();
    public static final Predicate<? extends Map<?, ?>> badMap = m -> m == null || m.isEmpty();

    @NotNull
    public static final <E> Predicate<? super Collection<E>> anyMatchInCollection(@Nullable Predicate<E> p) {
        return c -> c.stream().anyMatch(p == null ? Objects::isNull : p);
    }

    @NotNull
    public static final <EKey, EValue> Predicate<? super Map<EKey, EValue>> anyMatchInMap(@Nullable Predicate<EValue> p) {
        return m -> m.entrySet().stream().map(Map.Entry::getValue).anyMatch(p == null ? Objects::isNull : p);
    }

    @NotNull
    public static final <E> Predicate<? super Collection<E>> noneMatchInCollection(@Nullable Predicate<E> p) {
        return Preconditions.anyMatchInCollection(p).negate();
    }

    @NotNull
    public static final <EKey, EValue> Predicate<? super Map<EKey, EValue>> noneMatchInMap(@Nullable Predicate<EValue> p) {
        return Preconditions.anyMatchInMap(p).negate();
    }

    @NotNull
    private static final <E> Supplier<String> wrongCollectionMessage(@NotNull Collection<E> collection, @NotNull Predicate<E> invalidElement) {
        return () -> String.format(MESSAGE_WRONG_COLLECTION, Preconditions.getCountOfObjectsInCollection(collection, invalidElement), Preconditions.getIndexesOfObjectsInCollectionForLog(collection, invalidElement), collection.getClass());
    }

    @NotNull
    private static <EKey, EValue> Supplier<String> wrongMapMessage(@NotNull Map<EKey, EValue> map, @NotNull Predicate<EValue> invalidValue) {
        return () -> String.format(MESSAGE_WRONG_MAP, Preconditions.getCountOfObjectsInMap(map, invalidValue), Preconditions.getKeysOfObjectsInMapForLog(map, invalidValue), map.getClass());
    }

    public static <E> boolean isCheckArgument(E argument, @Nullable Predicate<E> wrong) {
        wrong = wrong == null ? Objects::isNull : wrong;
        return wrong.test(argument);
    }

    public static <E> E checkArgument(E argument, @Nullable Predicate<E> wrong, @Nullable String errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalArgumentException(errorMessage == null ? "" : errorMessage);
        }
        return argument;
    }

    public static <E> E checkArgument(E argument, @Nullable Predicate<E> wrong, @Nullable Supplier<String> errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalArgumentException(errorMessage == null ? "" : errorMessage.get());
        }
        return argument;
    }

    public static <E> E checkState(E argument, @Nullable Predicate<E> wrong, @Nullable String errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalStateException(errorMessage == null ? "" : errorMessage);
        }
        return argument;
    }

    public static <E> E checkState(E argument, @Nullable Predicate<E> wrong, @Nullable Supplier<String> errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalStateException(errorMessage == null ? "" : errorMessage.get());
        }
        return argument;
    }

    public static <E> E assertArgument(E argument, @Nullable Predicate<E> wrong, @Nullable String errorMessage) {
        assert (!Preconditions.isCheckArgument(argument, wrong)) : errorMessage == null ? "" : errorMessage;
        return argument;
    }

    public static <E> E assertArgument(E argument, @Nullable Predicate<E> wrong, @Nullable Supplier<String> errorMessage) {
        assert (!Preconditions.isCheckArgument(argument, wrong)) : errorMessage == null ? "" : errorMessage.get();
        return argument;
    }

    public static void checkArgument(boolean expression, @Nullable Supplier<String> errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage == null ? "" : errorMessage.get());
        }
    }

    public static void checkState(boolean expression, @Nullable Supplier<String> errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage == null ? "" : errorMessage.get());
        }
    }

    public static void assertArgument(boolean expression, @Nullable Supplier<String> errorMessage) {
        assert (expression) : errorMessage == null ? "" : errorMessage.get();
    }

    public static <E> E checkArgumentNotNull(E argument, @Nullable Supplier<String> errorMessage) {
        Preconditions.checkArgument(argument, Objects::isNull, errorMessage);
        return argument;
    }

    public static <E> E checkStateNotNull(E argument, @Nullable Supplier<String> errorMessage) {
        Preconditions.checkState(argument, Objects::isNull, errorMessage);
        return argument;
    }

    public static <E> E assertArgumentNotNull(E argument, @Nullable Supplier<String> errorMessage) {
        Preconditions.assertArgument(argument, Objects::isNull, errorMessage);
        return argument;
    }

    public static <E> Collection<E> checkArgument(Collection<E> collection, @Nullable Predicate<E> invalidElement) {
        Preconditions.checkArgument(collection);
        Preconditions.checkArgument(collection, Preconditions.anyMatchInCollection(invalidElement), Preconditions.wrongCollectionMessage(collection, invalidElement));
        return collection;
    }

    public static <EKey, EValue> Map<EKey, EValue> checkArgument(Map<EKey, EValue> map, @Nullable Predicate<EValue> invalidValue) {
        Preconditions.checkArgument(map);
        Preconditions.checkArgument(map, Preconditions.anyMatchInMap(invalidValue), Preconditions.wrongMapMessage(map, invalidValue));
        return map;
    }

    public static <E> boolean isCheckArgument(Collection<E> collection, @Nullable Predicate<E> invalidElement) {
        return badCollection.or(Preconditions.anyMatchInCollection(invalidElement)).test(collection);
    }

    public static <TKey, TValue> boolean isCheckArgument(Map<TKey, TValue> map, @Nullable Predicate<TValue> invalidValue) {
        return badMap.or(Preconditions.anyMatchInMap(invalidValue)).test(map);
    }

    public static <T extends Collection<E>, E> T checkState(T collection, @Nullable Predicate<E> invalidElement) {
        Preconditions.checkState(collection);
        Preconditions.checkState(collection, Preconditions.anyMatchInCollection(invalidElement), Preconditions.wrongCollectionMessage(collection, invalidElement));
        return collection;
    }

    public static <TKey, TValue> Map<TKey, TValue> checkState(Map<TKey, TValue> map, @Nullable Predicate<TValue> invalidValue) {
        Preconditions.checkState(map);
        Preconditions.checkState(map, Preconditions.anyMatchInMap(invalidValue), Preconditions.wrongMapMessage(map, invalidValue));
        return map;
    }

    public static <T extends Collection<E>, E> T assertArgument(T collection, @Nullable Predicate<E> invalidElement) {
        Preconditions.assertArgument(collection);
        Preconditions.assertArgument(collection, Preconditions.anyMatchInCollection(invalidElement), Preconditions.wrongCollectionMessage(collection, invalidElement));
        return collection;
    }

    public static <TKey, TValue> Map<TKey, TValue> assertArgument(Map<TKey, TValue> map, @Nullable Predicate<TValue> invalidValue) {
        Preconditions.assertArgument(map);
        Preconditions.assertArgument(map, Preconditions.anyMatchInMap(invalidValue), Preconditions.wrongMapMessage(map, invalidValue));
        return map;
    }

    public static <E extends Collection<?>> E checkArgument(E collection) {
        Preconditions.checkArgument(collection, Objects::isNull, MESSAGE_WRONG_COLLECTION_NULL);
        Preconditions.checkArgument(collection, Collection::isEmpty, MESSAGE_WRONG_COLLECTION_EMPTY);
        return collection;
    }

    public static boolean isCheckArgument(Collection<?> collection) {
        return badCollection.test(collection);
    }

    public static <E extends Collection<?>> E checkState(E collection) {
        Preconditions.checkState(collection, Objects::isNull, MESSAGE_WRONG_COLLECTION_NULL);
        Preconditions.checkState(collection, Collection::isEmpty, MESSAGE_WRONG_COLLECTION_EMPTY);
        return collection;
    }

    public static <E extends Collection<?>> E assertArgument(E collection) {
        Preconditions.assertArgument(collection, Objects::isNull, MESSAGE_WRONG_COLLECTION_NULL);
        Preconditions.assertArgument(collection, Collection::isEmpty, MESSAGE_WRONG_COLLECTION_EMPTY);
        return collection;
    }

    public static <TKey, TValue> Map<TKey, TValue> checkArgument(Map<TKey, TValue> map) {
        Preconditions.checkArgument(map, Objects::isNull, MESSAGE_WRONG_MAP_NULL);
        Preconditions.checkArgument(map, Map::isEmpty, MESSAGE_WRONG_MAP_EMPTY);
        return map;
    }

    public static boolean isCheckArgument(Map<?, ?> map) {
        return badMap.test(map);
    }

    public static <TKey, TValue> Map<TKey, TValue> checkState(Map<TKey, TValue> map) {
        Preconditions.checkState(map, Objects::isNull, MESSAGE_WRONG_MAP_NULL);
        Preconditions.checkState(map, Map::isEmpty, MESSAGE_WRONG_MAP_EMPTY);
        return map;
    }

    public static <TKey, TValue> Map<TKey, TValue> assertArgument(Map<TKey, TValue> map) {
        Preconditions.assertArgument(map, Objects::isNull, MESSAGE_WRONG_MAP_NULL);
        Preconditions.assertArgument(map, Map::isEmpty, MESSAGE_WRONG_MAP_EMPTY);
        return map;
    }

    public static String checkArgument(String string) {
        Preconditions.checkArgument(string, Objects::isNull, MESSAGE_WRONG_STRING_NULL);
        Preconditions.checkArgument(string, String::isEmpty, MESSAGE_WRONG_STRING_EMPTY);
        Preconditions.checkArgument(string, String::isBlank, MESSAGE_WRONG_STRING_BLANK);
        return string;
    }

    public static boolean isCheckArgument(String string) {
        return badString.test(string);
    }

    public static String checkState(String string) {
        Preconditions.checkState(string, Objects::isNull, MESSAGE_WRONG_STRING_NULL);
        Preconditions.checkState(string, String::isEmpty, MESSAGE_WRONG_STRING_EMPTY);
        Preconditions.checkState(string, String::isBlank, MESSAGE_WRONG_STRING_BLANK);
        return string;
    }

    public static String assertArgument(String string) {
        Preconditions.assertArgument(string, Objects::isNull, MESSAGE_WRONG_STRING_NULL);
        Preconditions.assertArgument(string, String::isEmpty, MESSAGE_WRONG_STRING_EMPTY);
        Preconditions.assertArgument(string, String::isBlank, MESSAGE_WRONG_STRING_BLANK);
        return string;
    }

    public static boolean isCheckArgument(long argument, @Nullable LongPredicate wrong) {
        wrong = wrong == null ? l -> l == 0L : wrong;
        return wrong.test(argument);
    }

    public static long checkArgument(long argument, @Nullable LongPredicate wrong, @Nullable String errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalArgumentException(errorMessage == null ? "" : errorMessage);
        }
        return argument;
    }

    public static long checkArgument(long argument, @Nullable LongPredicate wrong, @Nullable Supplier<String> errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalArgumentException(errorMessage == null ? "" : errorMessage.get());
        }
        return argument;
    }

    public static long checkState(long argument, @Nullable LongPredicate wrong, @Nullable String errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalStateException(errorMessage == null ? "" : errorMessage);
        }
        return argument;
    }

    public static long checkState(long argument, @Nullable LongPredicate wrong, @Nullable Supplier<String> errorMessage) {
        if (Preconditions.isCheckArgument(argument, wrong)) {
            throw new IllegalStateException(errorMessage == null ? "" : errorMessage.get());
        }
        return argument;
    }

    public static long assertArgument(long argument, @Nullable LongPredicate wrong, @Nullable String errorMessage) {
        assert (!Preconditions.isCheckArgument(argument, wrong)) : errorMessage == null ? "" : errorMessage;
        return argument;
    }

    public static long assertArgument(long argument, @Nullable LongPredicate wrong, @Nullable Supplier<String> errorMessage) {
        assert (!Preconditions.isCheckArgument(argument, wrong)) : errorMessage == null ? "" : errorMessage.get();
        return argument;
    }

    public static long checkArgument(long number) {
        Preconditions.checkArgument(number, badLong, MESSAGE_WRONG_NUMBER);
        return number;
    }

    public static boolean isCheckArgument(long number) {
        return badLong.test(number);
    }

    public static long checkState(long number) {
        Preconditions.checkState(number, badLong, MESSAGE_WRONG_NUMBER);
        return number;
    }

    public static long assertArgument(long number) {
        Preconditions.assertArgument(number, badLong, MESSAGE_WRONG_NUMBER);
        return number;
    }

    @NotNull
    public static <E> String getIndexesOfObjectsInCollection(@Nullable Collection<E> collection, @Nullable Predicate<E> filter) {
        if (collection == null || filter == null || collection.isEmpty()) {
            return "";
        }
        return Streams.mapWithIndex(collection.stream(), (o, i) -> Map.entry("" + i, o)).filter(e -> filter.test(e.getValue())).map(Map.Entry::getKey).collect(Collectors.joining(", "));
    }

    @NotNull
    public static <E> String getIndexesOfObjectsInCollectionForLog(@Nullable Collection<E> collection, @Nullable Predicate<E> filter) {
        if (collection == null || filter == null || collection.isEmpty()) {
            return "";
        }
        return Streams.mapWithIndex(collection.stream(), (o, i) -> Map.entry("" + i, o)).filter(e -> filter.test(e.getValue())).limit(80L).map(Map.Entry::getKey).collect(Collectors.joining(", "));
    }

    @NotNull
    public static <TKey, TValue> String getKeysOfObjectsInMap(@Nullable Map<TKey, TValue> map, @Nullable Predicate<TValue> filterValues) {
        if (map == null || filterValues == null || map.isEmpty()) {
            return "";
        }
        return map.entrySet().stream().filter(e -> filterValues.test(e.getValue())).map(e -> "" + e.getKey()).collect(Collectors.joining(", "));
    }

    @NotNull
    public static <TKey, TValue> String getKeysOfObjectsInMapForLog(@Nullable Map<TKey, TValue> map, @Nullable Predicate<TValue> filterValues) {
        if (map == null || filterValues == null || map.isEmpty()) {
            return "";
        }
        return map.entrySet().stream().filter(e -> filterValues.test(e.getValue())).limit(80L).map(e -> "" + e.getKey()).collect(Collectors.joining(", "));
    }

    @NotNull
    public static <E> long getCountOfObjectsInCollection(@Nullable Collection<E> collection, @Nullable Predicate<E> filter) {
        if (collection == null || filter == null || collection.isEmpty()) {
            return 0L;
        }
        return Streams.mapWithIndex(collection.stream(), (o, i) -> Map.entry("" + i, o)).filter(e -> filter.test(e.getValue())).map(Map.Entry::getKey).count();
    }

    @NotNull
    public static <TKey, TValue> long getCountOfObjectsInMap(@Nullable Map<TKey, TValue> map, @Nullable Predicate<TValue> filterValues) {
        if (map == null || filterValues == null || map.isEmpty()) {
            return 0L;
        }
        return map.entrySet().stream().map(Map.Entry::getValue).filter(filterValues).count();
    }
}

