/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.collect;

import com.google.common.collect.Range;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import life.expert.common.async.LogUtils;
import life.expert.common.graph.RenderGraph;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderCollection<T> {
    private static final Logger logger_ = LoggerFactory.getLogger(RenderGraph.class);
    @NonNull
    private Collection<T> collection;
    private Map<Integer, String> markElements = new HashMap<Integer, String>();
    private Map<Range<Integer>, String> markRanges = new HashMap<Range<Integer>, String>();

    private RenderCollection(@NotNull Collection<T> collection) {
        this.collection = collection;
    }

    public static <E> RenderCollection<E> collection(@NonNull Collection<E> collection) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        return new RenderCollection<E>(collection);
    }

    public RenderCollection<T> markElement(int index, @NonNull String property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        this.markElements.put(index, property);
        return this;
    }

    public RenderCollection<T> markElement(@NonNull Map<Integer, String> markElements) {
        if (markElements == null) {
            throw new NullPointerException("markElements is marked non-null but is null");
        }
        markElements.putAll(markElements);
        return this;
    }

    public RenderCollection<T> clearMarkElements() {
        this.markElements.clear();
        return this;
    }

    public RenderCollection<T> markRange(@NonNull Range<Integer> range, @NonNull String brackets) {
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        if (brackets == null) {
            throw new NullPointerException("brackets is marked non-null but is null");
        }
        this.markRanges.put(range, brackets);
        return this;
    }

    public RenderCollection<T> markRange(int left, int right, @NonNull String brackets) {
        if (brackets == null) {
            throw new NullPointerException("brackets is marked non-null but is null");
        }
        this.markRanges.put((Range<Integer>)Range.closed((Comparable)Integer.valueOf(left), (Comparable)Integer.valueOf(right)), brackets);
        return this;
    }

    public RenderCollection<T> markRanges(@NonNull Map<Range<Integer>, String> markRanges) {
        if (markRanges == null) {
            throw new NullPointerException("markRanges is marked non-null but is null");
        }
        markRanges.putAll(markRanges);
        return this;
    }

    public RenderCollection<T> clearMarkRanges() {
        this.markRanges.clear();
        return this;
    }

    public RenderCollection<T> buildToLog() {
        LogUtils.log(this.buildToString(), new Object[0]);
        return this;
    }

    public String buildToString() {
        String v;
        List list = this.collection.stream().map(i -> "" + i).collect(Collectors.toList());
        Range list_range = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(list.size() - 1));
        for (Map.Entry<Integer, String> entry : this.markElements.entrySet()) {
            String sym;
            Integer i2 = entry.getKey();
            v = entry.getValue();
            String string = v == null ? "*" : (sym = v.isBlank() ? "*" : v);
            if (!list_range.contains((Comparable)i2)) {
                LogUtils.logAtError("Element marker {} out of range in Collection of size {}", i2, list_range);
            }
            list.set(i2, "*" + (String)list.get(i2));
        }
        for (Map.Entry<Integer, String> entry : this.markRanges.entrySet()) {
            Range i2 = (Range)entry.getKey();
            v = entry.getValue();
            int mid = v.length() / 2;
            String v1 = v.substring(0, mid);
            String v2 = v.substring(mid);
            LogUtils.log("mid={} v1={} v2={}", mid, v1, v2);
            if (!list_range.encloses(i2)) {
                LogUtils.logAtError("Bracket marker {} out of range in Collection of size {}", i2, list_range);
            }
            int a = (Integer)i2.lowerEndpoint();
            int b = (Integer)i2.upperEndpoint();
            list.set(a, v1 + (String)list.get(a));
            list.set(b, (String)list.get(b) + v2);
        }
        return list.toString();
    }
}

