/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.graph;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.graph.ValueGraph;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import life.expert.common.async.LogUtils;
import life.expert.common.graph.RenderGraphStrategy;
import life.expert.common.io.FileUtils;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public final class RenderGraph<N> {
    private static final String DOT_OUTPUT_FOLDER = "src/main/graphviz/";
    private static final Logger logger_ = LoggerFactory.getLogger(RenderGraph.class);
    @NonNull
    private RenderGraphStrategy graph;
    private Map<N, String> markNodes = new HashMap<N, String>();
    private Map<EndpointPair<N>, String> markEdges = new HashMap<EndpointPair<N>, String>();

    private RenderGraph(@NotNull RenderGraphStrategy graph) {
        this.graph = graph;
    }

    public static <V> RenderGraph<V> graph(@NonNull Graph<V> graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        return new RenderGraph(RenderGraphStrategy.DefaultStrategy.of(graph));
    }

    public static <V, E> RenderGraph<V> graph(@NonNull Network<V, E> graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        return new RenderGraph(RenderGraphStrategy.NetworkStrategy.of(graph));
    }

    public static <V, I> RenderGraph<V> graph(@NonNull ValueGraph<V, I> graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        return new RenderGraph(RenderGraphStrategy.ValueStrategy.of(graph));
    }

    public static void deleteRenderedGraphFolder() {
        FileUtils.deleteFile(DOT_OUTPUT_FOLDER).subscribe();
    }

    public RenderGraph<N> markNode(@NonNull N node, @NonNull String property) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        this.markNodes.put(node, property);
        return this;
    }

    public RenderGraph<N> markNodes(@NonNull Map<N, String> markNodes) {
        if (markNodes == null) {
            throw new NullPointerException("markNodes is marked non-null but is null");
        }
        markNodes.putAll(markNodes);
        return this;
    }

    public RenderGraph<N> clearMarkNodes() {
        this.markNodes.clear();
        return this;
    }

    public RenderGraph<N> markEdge(@NonNull EndpointPair<N> edge, @NonNull String property) {
        if (edge == null) {
            throw new NullPointerException("edge is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        this.markEdges.put(edge, property);
        return this;
    }

    public RenderGraph<N> markEdge(@NonNull N nodeU, @NonNull N nodeV, @NonNull String property) {
        if (nodeU == null) {
            throw new NullPointerException("nodeU is marked non-null but is null");
        }
        if (nodeV == null) {
            throw new NullPointerException("nodeV is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        EndpointPair edge = this.graph.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
        this.markEdges.put(edge, property);
        return this;
    }

    public RenderGraph<N> markEdges(@NonNull Map<EndpointPair<N>, String> markEdges) {
        if (markEdges == null) {
            throw new NullPointerException("markEdges is marked non-null but is null");
        }
        markEdges.putAll(markEdges);
        return this;
    }

    public RenderGraph<N> clearMarkEdges() {
        this.markEdges.clear();
        return this;
    }

    public RenderGraph<N> buildToLog() {
        LogUtils.log(this.buildToString(), new Object[0]);
        return this;
    }

    public String buildToString() {
        return this.graph.renderToString(this.markNodes, this.markEdges);
    }

    public RenderGraph<N> buildToFile(String fileName) {
        String dot = this.buildToString();
        Mono new_file_flux = Mono.just((Object)(DOT_OUTPUT_FOLDER + fileName)).flatMap(FileUtils::createFileToMono).flatMap(FileUtils::writerFromPath);
        new_file_flux.subscribe(w -> w.write(dot), LogUtils.logAtErrorConsumer("ERROR"), LogUtils.logAtInfoRunnable("COMPLETE"));
        return this;
    }

    public RenderGraph<N> buildToFile() {
        String filename_with_datetime = String.format("%d.dot", Instant.now().toEpochMilli());
        return this.buildToFile(filename_with_datetime);
    }
}

