/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.graph;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.graph.ValueGraph;
import java.util.Map;
import lombok.NonNull;

public interface RenderGraphStrategy<N> {
    public boolean isDirected();

    public String renderToString(@NonNull Map<N, String> var1, @NonNull Map<EndpointPair<N>, String> var2);

    public static class ValueStrategy<N, V>
    implements RenderGraphStrategy<N> {
        @NonNull
        private ValueGraph<N, V> graph;

        @Override
        public boolean isDirected() {
            return false;
        }

        @Override
        public String renderToString(@NonNull Map<N, String> markNodes, @NonNull Map<EndpointPair<N>, String> markEdges) {
            if (markNodes == null) {
                throw new NullPointerException("markNodes is marked non-null but is null");
            }
            if (markEdges == null) {
                throw new NullPointerException("markEdges is marked non-null but is null");
            }
            StringBuilder dot = new StringBuilder();
            dot.append(this.graph.isDirected() ? "digraph G{\n\tratio = fill; node [shape = circle]; \n" : "graph G{\n\tratio = fill; node [shape = circle]; edge [dir=none];\n");
            for (Object n : this.graph.nodes()) {
                String description = markNodes.getOrDefault(n, "style=filled fillcolor=gray");
                dot.append(String.format("\t%s [%s];\n", n, description));
            }
            for (EndpointPair e : this.graph.edges()) {
                String value = this.graph.edgeValue(e).isPresent() ? String.format("label = \"%s\"", this.graph.edgeValue(e).get()) : "";
                String description = markEdges.getOrDefault(e, "");
                dot.append(String.format("\t%s %s %s [%s %s];\n", e.nodeU(), this.graph.isDirected() ? "->" : "--", e.nodeV(), value, description));
            }
            dot.append("}\n");
            return dot.toString();
        }

        private ValueStrategy(@NonNull ValueGraph<N, V> graph) {
            if (graph == null) {
                throw new NullPointerException("graph is marked non-null but is null");
            }
            this.graph = graph;
        }

        public static <N, V> ValueStrategy<N, V> of(@NonNull ValueGraph<N, V> graph) {
            return new ValueStrategy<N, V>(graph);
        }
    }

    public static class NetworkStrategy<N, E>
    implements RenderGraphStrategy<N> {
        @NonNull
        private Network<N, E> graph;

        @Override
        public boolean isDirected() {
            return false;
        }

        @Override
        public String renderToString(@NonNull Map<N, String> markNodes, @NonNull Map<EndpointPair<N>, String> markEdges) {
            if (markNodes == null) {
                throw new NullPointerException("markNodes is marked non-null but is null");
            }
            if (markEdges == null) {
                throw new NullPointerException("markEdges is marked non-null but is null");
            }
            StringBuilder dot = new StringBuilder();
            dot.append(this.graph.isDirected() ? "digraph G{\n\tratio = fill; node [shape = circle]; \n" : "graph G{\n\tratio = fill; node [shape = circle]; edge [dir=none];\n");
            for (Object n : this.graph.nodes()) {
                String description = markNodes.getOrDefault(n, "style=filled fillcolor=gray");
                dot.append(String.format("\t%s [%s];\n", n, description));
            }
            for (Object e : this.graph.edges()) {
                EndpointPair p = this.graph.incidentNodes(e);
                String value = String.format("label = \"%s\"", e);
                String description = markEdges.getOrDefault(e, "");
                dot.append(String.format("\t%s %s %s [%s %s];\n", p.nodeU(), this.graph.isDirected() ? "->" : "--", p.nodeV(), value, description));
            }
            dot.append("}\n");
            return dot.toString();
        }

        private NetworkStrategy(@NonNull Network<N, E> graph) {
            if (graph == null) {
                throw new NullPointerException("graph is marked non-null but is null");
            }
            this.graph = graph;
        }

        public static <N, E> NetworkStrategy<N, E> of(@NonNull Network<N, E> graph) {
            return new NetworkStrategy<N, E>(graph);
        }
    }

    public static class DefaultStrategy<N>
    implements RenderGraphStrategy<N> {
        @NonNull
        private Graph<N> graph;

        @Override
        public boolean isDirected() {
            return this.graph.isDirected();
        }

        @Override
        public String renderToString(@NonNull Map<N, String> markNodes, @NonNull Map<EndpointPair<N>, String> markEdges) {
            String description;
            if (markNodes == null) {
                throw new NullPointerException("markNodes is marked non-null but is null");
            }
            if (markEdges == null) {
                throw new NullPointerException("markEdges is marked non-null but is null");
            }
            StringBuilder dot = new StringBuilder();
            dot.append(this.graph.isDirected() ? "digraph G{\n\tratio = fill; node [shape = circle]; \n" : "graph G{\n\tratio = fill; node [shape = circle]; edge [dir=none];\n");
            for (Object n : this.graph.nodes()) {
                description = markNodes.getOrDefault(n, "style=filled fillcolor=gray");
                dot.append(String.format("\t%s [%s];\n", n, description));
            }
            for (EndpointPair e : this.graph.edges()) {
                description = markEdges.getOrDefault(e, String.format("label = \"%s\"", e));
                dot.append(String.format("\t%s %s %s [%s];\n", e.nodeU(), this.graph.isDirected() ? "->" : "--", e.nodeV(), description));
            }
            dot.append("}\n");
            return dot.toString();
        }

        private DefaultStrategy(@NonNull Graph<N> graph) {
            if (graph == null) {
                throw new NullPointerException("graph is marked non-null but is null");
            }
            this.graph = graph;
        }

        public static <N> DefaultStrategy<N> of(@NonNull Graph<N> graph) {
            return new DefaultStrategy<N>(graph);
        }
    }
}

