/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.io;

import io.vavr.API;
import io.vavr.CheckedFunction1;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.BaseStream;
import life.expert.common.function.CheckedUtils;
import life.expert.common.function.NullableUtils;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FileUtils {
    private static final Logger logger_ = LoggerFactory.getLogger(FileUtils.class);

    public static Mono<String> stringFromPath(Path path) {
        return Mono.justOrEmpty((Object)((String)API.unchecked((CheckedFunction1 & Serializable)p -> Files.readString(p)).apply((Object)path)));
    }

    public static Flux<String> linesFromPath(Mono<Path> path) {
        return path.flatMapMany(FileUtils::linesFromPath);
    }

    public static Flux<String> linesFromPath(Path path) {
        return Flux.using(() -> Files.lines(path), Flux::fromStream, BaseStream::close);
    }

    public static Flux<String> linesFromPath(String path) {
        return FileUtils.linesFromPath(Paths.get(path, new String[0]));
    }

    public static Mono<PrintWriter> writerFromPath(File file) {
        return Mono.using(() -> new PrintWriter(file), Mono::just, PrintWriter::close);
    }

    public static Mono<PrintWriter> writerFromPath(Path path) {
        return FileUtils.writerFromPath(path.toFile());
    }

    public static Mono<PrintWriter> writerFromPath(String path) {
        return FileUtils.writerFromPath(Paths.get(path, new String[0]));
    }

    public static Mono<Boolean> createFile(Path path) {
        return FileUtils.createFile((Mono<Path>)Mono.justOrEmpty((Object)path));
    }

    public static Mono<Path> createFileToMono(Path path) {
        return FileUtils.createFileToMono((Mono<Path>)Mono.justOrEmpty((Object)path));
    }

    public static Mono<Boolean> createFile(String path) {
        return FileUtils.createFile(Paths.get(path, new String[0]));
    }

    public static Mono<Path> createFileToMono(String path) {
        return FileUtils.createFileToMono(Paths.get(path, new String[0]));
    }

    public static Mono<Boolean> createFile(Mono<Path> path) {
        return path.map(Path::toFile).map(CheckedUtils.consumerToBoolean(org.apache.commons.io.FileUtils::touch));
    }

    public static Mono<Path> createFileToMono(Mono<Path> path) {
        return path.map(CheckedUtils.uncheckedFunction((CheckedFunction1 & Serializable)p -> {
            org.apache.commons.io.FileUtils.touch((File)p.toFile());
            return p;
        }));
    }

    public static Mono<Path> getPathForNewFile(String path, String defaultParentDirectory, String defaultFileName) {
        Flux path_ = Flux.from((Publisher)Mono.justOrEmpty((Object)path)).takeWhile(StringUtils::isNotBlank).map(p -> Paths.get(p, new String[0]));
        Flux default_name = Flux.from((Publisher)Mono.justOrEmpty((Object)defaultFileName)).takeWhile(StringUtils::isNotBlank).map(p -> Paths.get(p, new String[0]));
        Flux default_root = Flux.from((Publisher)Mono.justOrEmpty((Object)defaultParentDirectory)).takeWhile(StringUtils::isNotBlank).map(p -> Paths.get(p, new String[0]));
        Flux name = path_.flatMap(NullableUtils.nullableFunction(Path::getFileName)).switchIfEmpty((Publisher)default_name);
        Flux root = path_.flatMap(NullableUtils.nullableFunction(Path::getParent)).switchIfEmpty((Publisher)default_root);
        Mono name_root = Flux.concat((Publisher[])new Publisher[]{root, name}).reduce(Path::resolve);
        return name_root.single();
    }

    public static Mono<Boolean> createFile(String path, String defaultParentDirectory, String defaultFileName) {
        return FileUtils.createFile(FileUtils.getPathForNewFile(path, defaultParentDirectory, defaultFileName));
    }

    public static Mono<Path> createFileToMono(String path, String defaultParentDirectory, String defaultFileName) {
        return FileUtils.createFileToMono(FileUtils.getPathForNewFile(path, defaultParentDirectory, defaultFileName));
    }

    public static Mono<Boolean> deleteFile(Path path) {
        return FileUtils.deleteFile((Mono<Path>)Mono.justOrEmpty((Object)path));
    }

    public static Mono<Path> deleteFileToMono(Path path) {
        return FileUtils.deleteFileToMono((Mono<Path>)Mono.justOrEmpty((Object)path));
    }

    public static Mono<Boolean> deleteFile(String path) {
        return FileUtils.deleteFile(Paths.get(path, new String[0]));
    }

    public static Mono<Path> deleteFileToMono(String path) {
        return FileUtils.deleteFileToMono(Paths.get(path, new String[0]));
    }

    public static Mono<Boolean> deleteFile(Mono<Path> path) {
        return path.map(Path::toFile).map(CheckedUtils.consumerToBoolean(org.apache.commons.io.FileUtils::deleteQuietly));
    }

    public static Mono<Path> deleteFileToMono(Mono<Path> path) {
        return path.map(CheckedUtils.uncheckedFunction((CheckedFunction1 & Serializable)p -> {
            org.apache.commons.io.FileUtils.deleteQuietly((File)p.toFile());
            return p;
        }));
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

