/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.io;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Supplier;
import life.expert.common.async.LogUtils;
import life.expert.common.io.ConsumerIO;
import life.expert.common.io.RunnableIO;
import life.expert.common.io.SupplierIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileWrappers {
    private static final Logger logger_ = LoggerFactory.getLogger(FileWrappers.class);
    private static final String DEFAULT_FILENAME = "default.txt";

    public static Optional<URL> fileToUrl(@NotNull File file) {
        try {
            return Optional.ofNullable(file.toURI().toURL());
        }
        catch (NullPointerException | MalformedURLException e) {
            return Optional.empty();
        }
    }

    public static File createOrRetrieveFile(@Nullable String file, @Nullable Path directory) {
        Path defaultDir;
        String fileName = file;
        if (fileName == null || fileName.isBlank()) {
            fileName = DEFAULT_FILENAME;
        }
        if ((defaultDir = directory) == null) {
            defaultDir = Path.of("", new String[0]);
        }
        Path path = Paths.get(fileName, new String[0]);
        Path parent = path.getParent();
        try {
            if (parent == null) {
                path = defaultDir.resolve(fileName);
                LogUtils.log("Parent is null. Using default dir: {}", path.toAbsolutePath().toString());
            }
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]).toFile();
                LogUtils.log("Target file will be created: {}", path.toAbsolutePath().toString());
            } else {
                LogUtils.log("Target file will be retrieved: {}", path.toAbsolutePath().toString());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException("Please set correct path for file with filename. For example file  buildDir/architecture/classdiagram.dot ", exception);
        }
        return path.toFile();
    }

    public static void ioWrapper(@NotNull RunnableIO operation) {
        if (operation == null) {
            throw new NullPointerException();
        }
        try {
            operation.run();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void ioWrapper(@NotNull RunnableIO operation, @NotNull String errorMessage) {
        if (operation == null || errorMessage == null) {
            throw new NullPointerException();
        }
        try {
            operation.run();
        }
        catch (IOException exception) {
            throw new RuntimeException(errorMessage, exception);
        }
    }

    public static void ioWrapper(@NotNull RunnableIO operation, @NotNull Supplier<String> errorMessage) {
        if (operation == null || errorMessage == null) {
            throw new NullPointerException();
        }
        try {
            operation.run();
        }
        catch (IOException exception) {
            throw new RuntimeException(errorMessage.get(), exception);
        }
    }

    public static <E> E ioWrapper(@NotNull SupplierIO<E> operation) {
        if (operation == null) {
            throw new NullPointerException();
        }
        try {
            return operation.get();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <E> E ioWrapper(@NotNull SupplierIO<E> operation, @NotNull String errorMessage) {
        if (operation == null || errorMessage == null) {
            throw new NullPointerException();
        }
        try {
            return operation.get();
        }
        catch (IOException exception) {
            throw new RuntimeException(errorMessage, exception);
        }
    }

    public static <E> E ioWrapper(@NotNull SupplierIO<E> operation, @NotNull Supplier<String> errorMessage) {
        if (operation == null || errorMessage == null) {
            throw new NullPointerException();
        }
        try {
            return operation.get();
        }
        catch (IOException exception) {
            throw new RuntimeException(errorMessage.get(), exception);
        }
    }

    public static <E> Optional<E> ioOptional(@Nullable SupplierIO<E> operation) {
        if (operation == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(operation.get());
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    public static <E> void ioWrapper(@Nullable E input, @NotNull ConsumerIO<E> operation, @NotNull String errorMessage) {
        if (operation == null || errorMessage == null) {
            throw new NullPointerException();
        }
        try {
            operation.accept(input);
        }
        catch (IOException exception) {
            throw new RuntimeException(errorMessage, exception);
        }
    }

    public static <E> void ioWrapper(@Nullable E input, @NotNull ConsumerIO<E> operation) {
        if (operation == null) {
            throw new NullPointerException();
        }
        try {
            operation.accept(input);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <E> void ioWrapper(@Nullable E input, @NotNull ConsumerIO<E> operation, @NotNull Supplier<String> errorMessage) {
        if (operation == null || errorMessage == null) {
            throw new NullPointerException();
        }
        try {
            operation.accept(input);
        }
        catch (IOException exception) {
            throw new RuntimeException(errorMessage.get(), exception);
        }
    }

    public static RunnableIO writerWrapper(@NotNull File file, @NotNull Supplier<String> textToWrite) {
        if (file == null || textToWrite == null) {
            throw new NullPointerException();
        }
        return () -> {
            try (PrintWriter writer = new PrintWriter(file);){
                writer.print((String)textToWrite.get());
            }
        };
    }

    private FileWrappers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

