/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.reactivestreams;

import io.vavr.API;
import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Try;
import java.util.function.Function;
import life.expert.common.async.LogUtils;
import life.expert.common.function.CheckedUtils;
import life.expert.common.reactivestreams.Preconditions;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public final class Patterns {
    private static final Logger logger_ = LoggerFactory.getLogger(Patterns.class);

    public static <T> Mono<T> monoFromNullableTry(Try<T> tryObject) {
        if (tryObject == null) {
            return Preconditions.nullPointerMonoError("Input argument Try-object is null");
        }
        return (Mono)tryObject.map(Mono::justOrEmpty).getOrElseGet(Mono::error);
    }

    public static <T> Mono<T> monoFromTry(Try<T> tryObject) {
        if (tryObject == null) {
            return Preconditions.nullPointerMonoError("Input argument Try-object is null");
        }
        return (Mono)tryObject.map(Mono::just).getOrElseGet(Mono::error);
    }

    public static <T> Flux<T> fluxFromNullableTry(Try<T> tryObject) {
        if (tryObject == null) {
            return Preconditions.nullPointerError("Input argument Try-object is null");
        }
        return (Flux)tryObject.map(Mono::justOrEmpty).map(Mono::flux).getOrElseGet(Flux::error);
    }

    public static <T> Flux<T> fluxFromTry(Try<T> tryObject) {
        if (tryObject == null) {
            return Preconditions.nullPointerError("Input argument Try-object is null");
        }
        return (Flux)tryObject.map(Flux::just).getOrElseGet(Flux::error);
    }

    public static <T> Try<T> tryFromMono(Mono<T> mono) {
        if (mono == null) {
            return CheckedUtils.nullPointerFailure("Input argument Mono-object is null");
        }
        return (Try)mono.map(e -> API.Success((Object)e)).onErrorResume(err -> Mono.just((Object)API.Failure((Throwable)err))).block();
    }

    public static <T> Try<T> tryFromFlux(Flux<T> flux) {
        if (flux == null) {
            return CheckedUtils.nullPointerFailure("Input argument Flux-object is null");
        }
        return (Try)flux.map(e -> API.Success((Object)e)).onErrorResume(err -> Flux.just((Object)API.Failure((Throwable)err))).blockFirst();
    }

    public static <T, R> Function<T, Mono<R>> functionToMonoParallel(CheckedFunction1<T, R> function, Scheduler scheduler) {
        return t -> Mono.fromSupplier(() -> CheckedUtils.uncheckedFunction(function).apply(t)).subscribeOn(scheduler);
    }

    public static <T, R> Function<T, Mono<R>> functionToMonoParallelLogError(CheckedFunction1<T, R> function, Scheduler scheduler, String message) {
        return t -> Mono.fromSupplier(() -> CheckedUtils.uncheckedFunction(function).apply(t)).subscribeOn(scheduler).onErrorResume(LogUtils.logAtErrorFunction(message, Mono.never()));
    }

    public static Flux<Integer> range(int start, int end) {
        boolean reverse = start > end;
        return Flux.generate(() -> start, (i, f) -> {
            f.next(i);
            if (i == end) {
                f.complete();
            }
            return reverse ? i - 1 : i + 1;
        });
    }

    public static Flux<Long> longRange(long start, long end) {
        boolean reverse = start > end;
        return Flux.generate(() -> start, (i, f) -> {
            f.next(i);
            if (i == end) {
                f.complete();
            }
            return reverse ? i - 1L : i + 1L;
        });
    }

    public static <E> Flux<Tuple2<Integer, E>> indexed(Flux<E> flux) {
        if (flux == null) {
            return Preconditions.illegalArgumentError("Input argument flux must not be null.");
        }
        return flux.zipWith((Publisher)Flux.range((int)0, (int)Integer.MAX_VALUE), (e, i) -> Tuple.of((Object)i, (Object)e));
    }

    public static <E> Flux<Tuple2<Long, E>> longIndexed(Flux<E> flux) {
        if (flux == null) {
            return Preconditions.illegalArgumentError("Input argument flux must not be null.");
        }
        return flux.zipWith(Patterns.longRange(0L, Long.MAX_VALUE), (e, i) -> Tuple.of((Object)i, (Object)e));
    }

    private Patterns() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

