/*
 * Decompiled with CFR 0.152.
 */
package life.expert.common.reactivestreams;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.Tuple4;
import io.vavr.Tuple5;
import io.vavr.Tuple6;
import io.vavr.Tuple7;
import io.vavr.Tuple8;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import life.expert.common.function.CheckedUtils;
import life.expert.common.function.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Function3;
import reactor.function.Function4;
import reactor.function.Function5;
import reactor.function.Function6;
import reactor.function.Function7;
import reactor.function.Function8;
import reactor.function.Predicate3;
import reactor.function.Predicate4;
import reactor.function.Predicate5;
import reactor.function.Predicate6;
import reactor.function.Predicate7;
import reactor.function.Predicate8;

public final class Preconditions {
    private static final Logger logger_ = LoggerFactory.getLogger(Preconditions.class);

    public static <T> Mono<T> checkArgument(T argument, Predicate<T> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(argument);
    }

    public static <T, R> Mono<R> checkArgumentAndMap(T argument, Predicate<T> predicate, String message, Function<T, R> function) {
        return Preconditions.checkArgument(argument, predicate, message).map(function).single();
    }

    public static <T1, T2> Mono<Tuple2<T1, T2>> checkArgument(T1 argument1, T2 argument2, BiPredicate<T1, T2> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument1, argument2)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty((Object)Tuple.of(argument1, argument2));
    }

    public static <T1, T2, R> Mono<R> checkArgumentAndMap(T1 argument1, T2 argument2, BiPredicate<T1, T2> predicate, String message, BiFunction<T1, T2, R> function) {
        return Preconditions.checkArgument(argument1, argument2, predicate, message).map(TupleUtils.function(function)).single();
    }

    public static <T1, T2> Mono<Tuple2<T1, T2>> checkArgument(Tuple2<T1, T2> tuple, BiPredicate<T1, T2> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!TupleUtils.predicate(predicate).test(tuple)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(tuple);
    }

    public static <T1, T2, T3> Mono<Tuple3<T1, T2, T3>> checkArgument(T1 argument1, T2 argument2, T3 argument3, Predicate3<T1, T2, T3> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument1, argument2, argument3)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty((Object)Tuple.of(argument1, argument2, argument3));
    }

    public static <T1, T2, T3, R> Mono<R> checkArgumentAndMap(T1 argument1, T2 argument2, T3 argument3, Predicate3<T1, T2, T3> predicate, String message, Function3<T1, T2, T3, R> function) {
        return Preconditions.checkArgument(argument1, argument2, argument3, predicate, message).map(TupleUtils.function(function)).single();
    }

    public static <T1, T2, T3> Mono<Tuple3<T1, T2, T3>> checkArgument(Tuple3<T1, T2, T3> tuple, Predicate3<T1, T2, T3> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!TupleUtils.predicate(predicate).test(tuple)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(tuple);
    }

    public static <T1, T2, T3, T4> Mono<Tuple4<T1, T2, T3, T4>> checkArgument(T1 argument1, T2 argument2, T3 argument3, T4 argument4, Predicate4<T1, T2, T3, T4> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument1, argument2, argument3, argument4)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty((Object)Tuple.of(argument1, argument2, argument3, argument4));
    }

    public static <T1, T2, T3, T4, R> Mono<R> checkArgumentAndMap(T1 argument1, T2 argument2, T3 argument3, T4 argument4, Predicate4<T1, T2, T3, T4> predicate, String message, Function4<T1, T2, T3, T4, R> function) {
        return Preconditions.checkArgument(argument1, argument2, argument3, argument4, predicate, message).map(TupleUtils.function(function)).single();
    }

    public static <T1, T2, T3, T4> Mono<Tuple4<T1, T2, T3, T4>> checkArgument(Tuple4<T1, T2, T3, T4> tuple, Predicate4<T1, T2, T3, T4> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!TupleUtils.predicate(predicate).test(tuple)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(tuple);
    }

    public static <T1, T2, T3, T4, T5> Mono<Tuple5<T1, T2, T3, T4, T5>> checkArgument(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, Predicate5<T1, T2, T3, T4, T5> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument1, argument2, argument3, argument4, argument5)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty((Object)Tuple.of(argument1, argument2, argument3, argument4, argument5));
    }

    public static <T1, T2, T3, T4, T5, R> Mono<R> checkArgumentAndMap(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, Predicate5<T1, T2, T3, T4, T5> predicate, String message, Function5<T1, T2, T3, T4, T5, R> function) {
        return Preconditions.checkArgument(argument1, argument2, argument3, argument4, argument5, predicate, message).map(TupleUtils.function(function)).single();
    }

    public static <T1, T2, T3, T4, T5> Mono<Tuple5<T1, T2, T3, T4, T5>> checkArgument(Tuple5<T1, T2, T3, T4, T5> tuple, Predicate5<T1, T2, T3, T4, T5> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!TupleUtils.predicate(predicate).test(tuple)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(tuple);
    }

    public static <T1, T2, T3, T4, T5, T6> Mono<Tuple6<T1, T2, T3, T4, T5, T6>> checkArgument(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, T6 argument6, Predicate6<T1, T2, T3, T4, T5, T6> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument1, argument2, argument3, argument4, argument5, argument6)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty((Object)Tuple.of(argument1, argument2, argument3, argument4, argument5, argument6));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Mono<R> checkArgumentAndMap(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, T6 argument6, Predicate6<T1, T2, T3, T4, T5, T6> predicate, String message, Function6<T1, T2, T3, T4, T5, T6, R> function) {
        return Preconditions.checkArgument(argument1, argument2, argument3, argument4, argument5, argument6, predicate, message).map(TupleUtils.function(function)).single();
    }

    public static <T1, T2, T3, T4, T5, T6> Mono<Tuple6<T1, T2, T3, T4, T5, T6>> checkArgument(Tuple6<T1, T2, T3, T4, T5, T6> tuple, Predicate6<T1, T2, T3, T4, T5, T6> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!TupleUtils.predicate(predicate).test(tuple)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(tuple);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Mono<Tuple7<T1, T2, T3, T4, T5, T6, T7>> checkArgument(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, T6 argument6, T7 argument7, Predicate7<T1, T2, T3, T4, T5, T6, T7> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument1, argument2, argument3, argument4, argument5, argument6, argument7)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty((Object)Tuple.of(argument1, argument2, argument3, argument4, argument5, argument6, argument7));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Mono<R> checkArgumentAndMap(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, T6 argument6, T7 argument7, Predicate7<T1, T2, T3, T4, T5, T6, T7> predicate, String message, Function7<T1, T2, T3, T4, T5, T6, T7, R> function) {
        return Preconditions.checkArgument(argument1, argument2, argument3, argument4, argument5, argument6, argument7, predicate, message).map(TupleUtils.function(function)).single();
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Mono<Tuple7<T1, T2, T3, T4, T5, T6, T7>> checkArgument(Tuple7<T1, T2, T3, T4, T5, T6, T7> tuple, Predicate7<T1, T2, T3, T4, T5, T6, T7> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!TupleUtils.predicate(predicate).test(tuple)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(tuple);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Mono<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> checkArgument(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, T6 argument6, T7 argument7, T8 argument8, Predicate8<T1, T2, T3, T4, T5, T6, T7, T8> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!predicate.test(argument1, argument2, argument3, argument4, argument5, argument6, argument7, argument8)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty((Object)Tuple.of(argument1, argument2, argument3, argument4, argument5, argument6, argument7, argument8));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Mono<R> checkArgumentAndMap(T1 argument1, T2 argument2, T3 argument3, T4 argument4, T5 argument5, T6 argument6, T7 argument7, T8 argument8, Predicate8<T1, T2, T3, T4, T5, T6, T7, T8> predicate, String message, Function8<T1, T2, T3, T4, T5, T6, T7, T8, R> function) {
        return Preconditions.checkArgument(argument1, argument2, argument3, argument4, argument5, argument6, argument7, argument8, predicate, message).map(TupleUtils.function(function)).single();
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Mono<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> checkArgument(Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> tuple, Predicate8<T1, T2, T3, T4, T5, T6, T7, T8> predicate, String message) {
        if (predicate == null) {
            return Preconditions.nullPointerMonoError("Predicate must not be null");
        }
        if (!TupleUtils.predicate(predicate).test(tuple)) {
            return Preconditions.illegalArgumentMonoError(message);
        }
        return Mono.justOrEmpty(tuple);
    }

    public static <T> Mono<T> checkArgument(T argument, Predicate<T> predicate) {
        return Preconditions.checkArgument(argument, predicate, "Condition should evaluate to true");
    }

    public static <T> Mono<T> checkTrue(boolean condition) {
        return Preconditions.checkTrue(condition, "Condition should be true");
    }

    public static <T> Mono<T> checkTrue(boolean condition, String message) {
        return condition ? Mono.empty() : Mono.error((Throwable)new IllegalArgumentException(message == null ? "Condition should be true" : message));
    }

    public static <T> Mono<T> checkFalse(boolean condition) {
        return Preconditions.checkFalse(!condition, "Condition should be false");
    }

    public static <T> Mono<T> checkFalse(boolean condition, String message) {
        return !condition ? Mono.empty() : Mono.error((Throwable)new IllegalArgumentException(message == null ? "Condition should be false" : message));
    }

    public static <T> Mono<T> checkNotNull(T argument, String message) {
        return Mono.justOrEmpty(argument).single().onErrorMap(CheckedUtils.nullPointerException(message == null ? "Argument should not be null" : message));
    }

    public static <T> Mono<T> checkNotNull(T argument) {
        return Preconditions.checkNotNull(argument, "Argument should not be null");
    }

    public static <T> Flux<T> nullPointerError() {
        return Flux.defer(() -> Flux.error((Throwable)new NullPointerException()));
    }

    public static <T> Flux<T> nullPointerError(String description) {
        return Flux.defer(() -> Flux.error((Throwable)new NullPointerException(description == null ? "" : description)));
    }

    public static <T> Flux<T> illegalArgumentError() {
        return Flux.defer(() -> Flux.error((Throwable)new IllegalArgumentException()));
    }

    public static <T> Flux<T> illegalArgumentError(String description) {
        return Flux.defer(() -> Flux.error((Throwable)new IllegalArgumentException(description == null ? "" : description)));
    }

    public static <T> Flux<T> illegalArgumentError(String description, Throwable cause) {
        return Flux.defer(() -> Flux.error((Throwable)new IllegalArgumentException(description == null ? "" : description, cause)));
    }

    public static <T> Flux<T> illegalStateError() {
        return Flux.defer(() -> Flux.error((Throwable)new IllegalStateException()));
    }

    public static <T> Flux<T> illegalStateError(String description) {
        return Flux.defer(() -> Flux.error((Throwable)new IllegalStateException(description == null ? "" : description)));
    }

    public static <T> Flux<T> illegalStateError(String description, Throwable cause) {
        return Flux.defer(() -> Flux.error((Throwable)new IllegalStateException(description == null ? "" : description, cause)));
    }

    public static <T> Mono<T> nullPointerMonoError() {
        return Mono.defer(() -> Mono.error((Throwable)new NullPointerException()));
    }

    public static <T> Mono<T> nullPointerMonoError(String description) {
        return Mono.defer(() -> Mono.error((Throwable)new NullPointerException(description == null ? "" : description)));
    }

    public static <T> Mono<T> illegalArgumentMonoError() {
        return Mono.defer(() -> Mono.error((Throwable)new IllegalArgumentException()));
    }

    public static <T> Mono<T> illegalArgumentMonoError(String description) {
        return Mono.defer(() -> Mono.error((Throwable)new IllegalArgumentException(description == null ? "" : description)));
    }

    public static <T> Mono<T> illegalArgumentMonoError(String description, Throwable cause) {
        return Mono.defer(() -> Mono.error((Throwable)new IllegalArgumentException(description == null ? "" : description, cause)));
    }

    public static <T> Mono<T> illegalStateMonoError() {
        return Mono.defer(() -> Mono.error((Throwable)new IllegalStateException()));
    }

    public static <T> Mono<T> illegalStateMonoError(String description) {
        return Mono.defer(() -> Mono.error((Throwable)new IllegalStateException(description == null ? "" : description)));
    }

    public static <T> Mono<T> illegalStateMonoError(String description, Throwable cause) {
        return Mono.defer(() -> Mono.error((Throwable)new IllegalStateException(description == null ? "" : description, cause)));
    }

    private Preconditions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

