/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric;

import com.google.common.collect.ComparisonChain;
import io.vavr.Tuple;
import io.vavr.Tuple1;
import io.vavr.match.annotation.Patterns;
import io.vavr.match.annotation.Unapply;
import life.expert.common.function.TupleUtils;
import life.expert.common.reactivestreams.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Patterns
public final class PositiveInteger
implements Comparable<PositiveInteger> {
    private static final Logger logger_ = LoggerFactory.getLogger(PositiveInteger.class);
    private final int number;

    private static Mono<PositiveInteger> monoOf_(int number) {
        return Mono.fromSupplier(() -> new PositiveInteger(number));
    }

    public static Mono<PositiveInteger> monoOf(int number) {
        if (number < 1) {
            return Preconditions.illegalArgumentMonoError("Input argument must posititve >0 .");
        }
        return PositiveInteger.monoOf_(number);
    }

    @Deprecated
    public static PositiveInteger of(int number) {
        return (PositiveInteger)PositiveInteger.monoOf(number).block();
    }

    public static Mono<PositiveInteger> monoOfTuple(Tuple1<Integer> tuple) {
        if (tuple == null) {
            return Preconditions.illegalArgumentMonoError("Input tuple must not be null.");
        }
        return TupleUtils.function(PositiveInteger::monoOf).apply(tuple);
    }

    public static Mono<PositiveInteger> monoOfMonoWithTuple(Mono<Tuple1<Integer>> tuple) {
        if (tuple == null) {
            return Preconditions.illegalArgumentMonoError("Input Mono must not be null.");
        }
        return tuple.flatMap(PositiveInteger::monoOfTuple);
    }

    public static Mono<PositiveInteger> monoOfMono(Mono<Integer> number) {
        if (number == null) {
            return Preconditions.illegalArgumentMonoError("Input Mono must not be null.");
        }
        return number.flatMap(PositiveInteger::monoOf);
    }

    public static Mono<PositiveInteger> copyOf(PositiveInteger other) {
        return PositiveInteger.monoOf_(other.getNumber());
    }

    @Unapply
    static Tuple1<Integer> PositiveInteger(PositiveInteger object) {
        return Tuple.of((Object)object.getNumber());
    }

    public String toString() {
        return "" + this.number;
    }

    @Override
    public int compareTo(PositiveInteger o) {
        return ComparisonChain.start().compare(this.number, o.number).result();
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PositiveInteger)) {
            return false;
        }
        PositiveInteger other = (PositiveInteger)o;
        return this.getNumber() == other.getNumber();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumber();
        return result;
    }

    private PositiveInteger(int number) {
        this.number = number;
    }
}

