/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric;

import com.google.common.collect.ComparisonChain;
import io.vavr.Tuple;
import io.vavr.Tuple1;
import io.vavr.match.annotation.Patterns;
import io.vavr.match.annotation.Unapply;
import life.expert.common.function.TupleUtils;
import life.expert.common.reactivestreams.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Patterns
public final class PositiveLong
implements Comparable<PositiveLong> {
    private static final Logger logger_ = LoggerFactory.getLogger(PositiveLong.class);
    private final long number;

    private static Mono<PositiveLong> monoOf_(long number) {
        return Mono.fromSupplier(() -> new PositiveLong(number));
    }

    public static Mono<PositiveLong> monoOf(long number) {
        if (number < 1L) {
            return Preconditions.illegalArgumentMonoError("Input argument must posititve >0 .");
        }
        return PositiveLong.monoOf_(number);
    }

    @Deprecated
    public static PositiveLong of(long number) {
        return (PositiveLong)PositiveLong.monoOf(number).block();
    }

    public static Mono<PositiveLong> monoOfTuple(Tuple1<Long> tuple) {
        if (tuple == null) {
            return Preconditions.illegalArgumentMonoError("Input tuple must not be null.");
        }
        return TupleUtils.function(PositiveLong::monoOf).apply(tuple);
    }

    public static Mono<PositiveLong> monoOfMonoWithTuple(Mono<Tuple1<Long>> tuple) {
        if (tuple == null) {
            return Preconditions.illegalArgumentMonoError("Input Mono must not be null.");
        }
        return tuple.flatMap(PositiveLong::monoOfTuple);
    }

    public static Mono<PositiveLong> monoOfMono(Mono<Long> number) {
        if (number == null) {
            return Preconditions.illegalArgumentMonoError("Input Mono must not be null.");
        }
        return number.flatMap(PositiveLong::monoOf);
    }

    public static Mono<PositiveLong> copyOf(PositiveLong other) {
        return PositiveLong.monoOf_(other.getNumber());
    }

    @Unapply
    static Tuple1<Long> PositiveLong(PositiveLong object) {
        return Tuple.of((Object)object.getNumber());
    }

    public String toString() {
        return "" + this.number;
    }

    @Override
    public int compareTo(PositiveLong o) {
        return ComparisonChain.start().compare(this.number, o.number).result();
    }

    public long getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PositiveLong)) {
            return false;
        }
        PositiveLong other = (PositiveLong)o;
        return this.getNumber() == other.getNumber();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $number = this.getNumber();
        result = result * 59 + (int)($number >>> 32 ^ $number);
        return result;
    }

    private PositiveLong(long number) {
        this.number = number;
    }
}

