/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.amount;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import life.expert.value.numeric.amount.Quantity;
import life.expert.value.numeric.context.AmountContext;
import life.expert.value.numeric.operators.Operator;
import life.expert.value.numeric.unit.Piece;
import life.expert.value.numeric.unit.Unit;
import life.expert.value.numeric.utils.AmountParseException;
import life.expert.value.numeric.utils.DefaultNumberValue;
import life.expert.value.numeric.utils.NumberUtils;
import life.expert.value.numeric.utils.NumberValue;
import life.expert.value.numeric.utils.ValueException;

public final class BigAmount
implements Quantity,
Comparable<Quantity> {
    public static final AmountContext DEFAULT_CONTEXT = AmountContext.of(BigAmount.class, 256, false, 63, RoundingMode.HALF_EVEN);
    public static final AmountContext MAX_CONTEXT = AmountContext.of(BigAmount.class, 0, false, -1, RoundingMode.HALF_EVEN);
    private final Unit unit;
    private final AmountContext amountContext;
    private final BigDecimal number;

    private BigAmount(BigDecimal number, Unit unit) {
        this(number, unit, null);
    }

    private BigAmount(BigDecimal number, Unit unit, AmountContext amountContext) {
        Objects.requireNonNull(unit, "Unit is required.");
        this.unit = unit;
        this.amountContext = Objects.nonNull(amountContext) ? amountContext : DEFAULT_CONTEXT;
        Objects.requireNonNull(number, "Number is required.");
        this.number = NumberUtils.getBigDecimal(number, amountContext);
    }

    public static BigAmount of(BigDecimal number, Unit unit) {
        return new BigAmount(number, unit);
    }

    public static BigAmount of(BigDecimal number, Unit unit, AmountContext amountContext) {
        return new BigAmount(number, unit, amountContext);
    }

    public static BigAmount of(Number number, Unit unit) {
        return new BigAmount(NumberUtils.getBigDecimal(number), unit);
    }

    public static BigAmount of(Number number, Unit unit, AmountContext amountContext) {
        return new BigAmount(NumberUtils.getBigDecimal(number), unit, amountContext);
    }

    public static BigAmount of(Number number, String unitCode) {
        return new BigAmount(NumberUtils.getBigDecimal(number), Piece.of(unitCode));
    }

    public static BigAmount of(BigDecimal number, String unitCode) {
        return new BigAmount(number, Piece.of(unitCode));
    }

    public static BigAmount of(Number number, String unitCode, AmountContext amountContext) {
        return new BigAmount(NumberUtils.getBigDecimal(number), Piece.of(unitCode), amountContext);
    }

    public static BigAmount of(BigDecimal number, String unitCode, AmountContext amountContext) {
        return new BigAmount(number, Piece.of(unitCode), amountContext);
    }

    public static BigAmount zero(Unit unit) {
        return new BigAmount(BigDecimal.ZERO, unit);
    }

    public static BigAmount ofMinor(Unit unit, long amountMinor) {
        return BigAmount.ofMinor(unit, amountMinor, unit.getDefaultFractionDigits());
    }

    public static BigAmount ofMinor(Unit unit, long amountMinor, int fractionDigits) {
        if (fractionDigits < 0) {
            throw new IllegalArgumentException("The fractionDigits cannot be negative");
        }
        return BigAmount.of(BigDecimal.valueOf(amountMinor, fractionDigits), unit);
    }

    public static BigAmount from(Quantity amt) {
        if (amt.getClass() == BigAmount.class) {
            return (BigAmount)amt;
        }
        return BigAmount.of(amt.getNumber().numberValue(BigDecimal.class), amt.getUnit(), (AmountContext)amt.getContext());
    }

    public static BigAmount parse(CharSequence text) {
        String[] array = Objects.requireNonNull(text).toString().split(" ");
        if (array.length != 2) {
            throw new AmountParseException("An error happened when try to parse the Amount.", text, 0);
        }
        String parsed_unit = array[0];
        BigDecimal number = new BigDecimal(array[1]);
        return BigAmount.of(number, (Unit)Piece.of(parsed_unit));
    }

    public BigDecimal getNumberStripped() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        return this.number.stripTrailingZeros();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public AmountContext getContext() {
        return this.amountContext;
    }

    @Override
    public NumberValue getNumber() {
        return new DefaultNumberValue(this.number);
    }

    @Override
    public int compareTo(Quantity o) {
        Objects.requireNonNull(o);
        int compare = this.getUnit().getCode().compareTo(o.getUnit().getCode());
        if (compare == 0) {
            compare = this.number.compareTo(BigAmount.from((Quantity)o).number);
        }
        return compare;
    }

    @Override
    public BigAmount abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    @Override
    public BigAmount divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divide(BigDecimal.valueOf(divisor));
    }

    @Override
    public BigAmount divide(double divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return BigAmount.of((Number)0, this.getUnit());
        }
        if (divisor == 1.0) {
            return this;
        }
        return this.divide(new BigDecimal(String.valueOf(divisor)));
    }

    public BigAmount[] divideAndRemainder(long divisor) {
        return this.divideAndRemainder(BigDecimal.valueOf(divisor));
    }

    public BigAmount[] divideAndRemainder(double divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            BigAmount zero = BigAmount.of((Number)0, this.getUnit());
            return new BigAmount[]{zero, zero};
        }
        return this.divideAndRemainder(new BigDecimal(String.valueOf(divisor)));
    }

    @Override
    public BigAmount multiply(long multiplicand) {
        if (multiplicand == 1L) {
            return this;
        }
        return this.multiply(BigDecimal.valueOf(multiplicand));
    }

    @Override
    public BigAmount multiply(double multiplicand) {
        NumberUtils.checkNoInfinityOrNaN(multiplicand);
        if (multiplicand == 1.0) {
            return this;
        }
        return this.multiply(new BigDecimal(String.valueOf(multiplicand)));
    }

    @Override
    public BigAmount remainder(long divisor) {
        return this.remainder(BigDecimal.valueOf(divisor));
    }

    @Override
    public BigAmount remainder(double divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return BigAmount.of((Number)0, this.getUnit());
        }
        return this.remainder(new BigDecimal(String.valueOf(divisor)));
    }

    @Override
    public boolean isZero() {
        return this.signum() == 0;
    }

    @Override
    public boolean isPositive() {
        return this.signum() == 1;
    }

    @Override
    public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    @Override
    public boolean isNegative() {
        return this.signum() == -1;
    }

    @Override
    public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    @Override
    public BigAmount with(Operator operator) {
        Objects.requireNonNull(operator);
        try {
            return (BigAmount)BigAmount.class.cast(operator.apply(this));
        }
        catch (ValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueException("Operator failed: " + operator, e);
        }
    }

    @Override
    public BigAmount add(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        if (amount.isZero()) {
            return this;
        }
        MathContext mc = NumberUtils.getMathContext(this.amountContext, RoundingMode.HALF_EVEN);
        return new BigAmount(this.number.add(amount.getNumber().numberValue(BigDecimal.class), mc), this.getUnit(), this.amountContext);
    }

    @Override
    public BigAmount divide(Number divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return BigAmount.of((Number)0, this.getUnit());
        }
        BigDecimal divisorBD = NumberUtils.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return this;
        }
        MathContext mc = NumberUtils.getMathContext(this.amountContext, RoundingMode.HALF_EVEN);
        int maxScale = this.amountContext.getMaxScale();
        if (maxScale > 0) {
            return new BigAmount(this.number.divide(divisorBD, maxScale, mc.getRoundingMode()), this.getUnit(), this.amountContext);
        }
        return new BigAmount(this.number.divide(divisorBD, mc), this.getUnit(), this.amountContext);
    }

    public BigAmount[] divideAndRemainder(Number divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            BigAmount zero = BigAmount.of((Number)0, this.getUnit());
            return new BigAmount[]{zero, zero};
        }
        BigDecimal divisorBD = NumberUtils.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return new BigAmount[]{this, new BigAmount(BigDecimal.ZERO, this.getUnit())};
        }
        MathContext mc = NumberUtils.getMathContext(this.amountContext, RoundingMode.HALF_EVEN);
        BigDecimal[] dec = this.number.divideAndRemainder(divisorBD, mc);
        return new BigAmount[]{new BigAmount(dec[0], this.getUnit(), this.amountContext), new BigAmount(dec[1], this.getUnit(), this.amountContext)};
    }

    @Override
    public BigAmount divideToIntegralValue(long divisor) {
        return this.divideToIntegralValue(NumberUtils.getBigDecimal(divisor));
    }

    @Override
    public BigAmount divideToIntegralValue(double divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return BigAmount.of((Number)0, this.getUnit());
        }
        return this.divideToIntegralValue(NumberUtils.getBigDecimal(divisor));
    }

    @Override
    public BigAmount divideToIntegralValue(Number divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return BigAmount.of((Number)0, this.getUnit());
        }
        MathContext mc = NumberUtils.getMathContext(this.amountContext, RoundingMode.HALF_EVEN);
        BigDecimal divisorBD = NumberUtils.getBigDecimal(divisor);
        BigDecimal dec = this.number.divideToIntegralValue(divisorBD, mc);
        return new BigAmount(dec, this.getUnit(), this.amountContext);
    }

    @Override
    public BigAmount multiply(Number multiplicand) {
        NumberUtils.checkNoInfinityOrNaN(multiplicand);
        BigDecimal multiplicandBD = NumberUtils.getBigDecimal(multiplicand);
        if (multiplicandBD.equals(BigDecimal.ONE)) {
            return this;
        }
        MathContext mc = NumberUtils.getMathContext(this.amountContext, RoundingMode.HALF_EVEN);
        BigDecimal dec = this.number.multiply(multiplicandBD, mc);
        return new BigAmount(dec, this.getUnit(), this.amountContext);
    }

    @Override
    public BigAmount negate() {
        return new BigAmount(this.number.negate(), this.getUnit());
    }

    @Override
    public BigAmount plus() {
        return this;
    }

    @Override
    public BigAmount subtract(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        if (amount.isZero()) {
            return this;
        }
        MathContext mc = NumberUtils.getMathContext(this.amountContext, RoundingMode.HALF_EVEN);
        return new BigAmount(this.number.subtract(amount.getNumber().numberValue(BigDecimal.class), mc), this.getUnit(), this.amountContext);
    }

    @Override
    public BigAmount stripTrailingZeros() {
        if (this.isZero()) {
            return new BigAmount(BigDecimal.ZERO, this.getUnit());
        }
        return new BigAmount(this.number.stripTrailingZeros(), this.getUnit(), this.amountContext);
    }

    @Override
    public BigAmount remainder(Number divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return new BigAmount(BigDecimal.ZERO, this.getUnit());
        }
        MathContext mc = NumberUtils.getMathContext(this.amountContext, RoundingMode.HALF_EVEN);
        BigDecimal bd = NumberUtils.getBigDecimal(divisor);
        return new BigAmount(this.number.remainder(bd, mc), this.getUnit(), this.amountContext);
    }

    @Override
    public BigAmount scaleByPowerOfTen(int power) {
        return new BigAmount(this.number.scaleByPowerOfTen(power), this.getUnit(), this.amountContext);
    }

    @Override
    public int signum() {
        return this.number.signum();
    }

    @Override
    public boolean isLessThan(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) <= 0;
    }

    @Override
    public boolean isGreaterThan(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) >= 0;
    }

    @Override
    public boolean isEqualTo(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) == 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BigAmount) {
            BigAmount other = (BigAmount)obj;
            return Objects.equals(this.getUnit(), other.getUnit()) && Objects.equals(this.getNumberStripped(), other.getNumberStripped());
        }
        return false;
    }

    public String toString() {
        return this.getUnit().getCode() + " " + this.number.toPlainString();
    }

    public int hashCode() {
        return Objects.hash(this.getUnit(), this.getNumberStripped());
    }
}

