/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.amount;

import life.expert.value.numeric.context.Context;
import life.expert.value.numeric.operators.Operator;
import life.expert.value.numeric.unit.Unit;
import life.expert.value.numeric.utils.NumberValue;

public interface Quantity
extends Comparable<Quantity> {
    public Context getContext();

    public Unit getUnit();

    public NumberValue getNumber();

    default public Quantity with(Operator operator) {
        return operator.apply(this);
    }

    public boolean isGreaterThan(Quantity var1);

    public boolean isGreaterThanOrEqualTo(Quantity var1);

    public boolean isLessThan(Quantity var1);

    public boolean isLessThanOrEqualTo(Quantity var1);

    public boolean isEqualTo(Quantity var1);

    default public boolean isNegative() {
        return this.signum() < 0;
    }

    default public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    default public boolean isPositive() {
        return this.signum() > 0;
    }

    default public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    default public boolean isZero() {
        return this.signum() == 0;
    }

    public int signum();

    public Quantity add(Quantity var1);

    public Quantity subtract(Quantity var1);

    public Quantity multiply(long var1);

    public Quantity multiply(double var1);

    public Quantity multiply(Number var1);

    public Quantity divide(long var1);

    public Quantity divide(double var1);

    public Quantity divide(Number var1);

    public Quantity remainder(long var1);

    public Quantity remainder(double var1);

    public Quantity remainder(Number var1);

    public Quantity[] divideAndRemainder(long var1);

    public Quantity[] divideAndRemainder(double var1);

    public Quantity[] divideAndRemainder(Number var1);

    public Quantity divideToIntegralValue(long var1);

    public Quantity divideToIntegralValue(double var1);

    public Quantity divideToIntegralValue(Number var1);

    public Quantity scaleByPowerOfTen(int var1);

    public Quantity abs();

    public Quantity negate();

    public Quantity plus();

    public Quantity stripTrailingZeros();
}

