/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.amount;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import life.expert.value.numeric.amount.Amount;
import life.expert.value.numeric.amount.BigAmount;
import life.expert.value.numeric.amount.Quantity;
import life.expert.value.numeric.context.AmountContext;
import life.expert.value.numeric.operators.Operator;
import life.expert.value.numeric.unit.Piece;
import life.expert.value.numeric.unit.Unit;
import life.expert.value.numeric.utils.AmountParseException;
import life.expert.value.numeric.utils.DefaultNumberValue;
import life.expert.value.numeric.utils.NumberUtils;
import life.expert.value.numeric.utils.NumberValue;
import life.expert.value.numeric.utils.ValueException;

public final class RoundedAmount
implements Quantity,
Comparable<Quantity> {
    public static final AmountContext DEFAULT_CONTEXT = AmountContext.of(RoundedAmount.class, 256, false, 63, RoundingMode.HALF_EVEN);
    private final Unit unit;
    private final AmountContext amountContext;
    private final BigDecimal number;
    private final Operator rounding;

    public RoundedAmount ulp() {
        return new RoundedAmount((Number)this.number.ulp(), this.unit, this.rounding);
    }

    public RoundedAmount pow(int n) {
        return new RoundedAmount((Number)this.number.pow(n, Optional.ofNullable(this.amountContext.getMathContext()).orElse(MathContext.DECIMAL64)), this.unit, this.rounding).with(this.rounding);
    }

    public RoundedAmount with(Number amount) {
        this.checkNumber(amount);
        return new RoundedAmount((Number)NumberUtils.getBigDecimal(amount), this.unit, this.rounding);
    }

    public RoundedAmount with(Unit unit) {
        Objects.requireNonNull(unit, "unit required");
        return new RoundedAmount((Number)this.asType(BigDecimal.class), unit, this.rounding);
    }

    public RoundedAmount with(Unit unit, Number amount) {
        this.checkNumber(amount);
        return new RoundedAmount((Number)NumberUtils.getBigDecimal(amount), unit, this.rounding);
    }

    public int getScale() {
        return this.number.scale();
    }

    public int getPrecision() {
        return this.number.precision();
    }

    @Deprecated
    public <T> T asType(Class<T> type) {
        if (BigDecimal.class.equals(type)) {
            return (T)this.number;
        }
        if (Number.class.equals(type)) {
            return (T)this.number;
        }
        if (Double.class.equals(type)) {
            return (T)Double.valueOf(this.number.doubleValue());
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(this.number.floatValue());
        }
        if (Long.class.equals(type)) {
            return (T)Long.valueOf(this.number.longValue());
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(this.number.intValue());
        }
        if (Short.class.equals(type)) {
            return (T)Short.valueOf(this.number.shortValue());
        }
        if (Byte.class.equals(type)) {
            return (T)Byte.valueOf(this.number.byteValue());
        }
        if (BigInteger.class.equals(type)) {
            return (T)this.number.toBigInteger();
        }
        throw new IllegalArgumentException("Unsupported representation type: " + type);
    }

    @Deprecated
    public <T> T asType(Class<T> type, Operator adjuster) {
        RoundedAmount amount = (RoundedAmount)adjuster.apply(this);
        return amount.asType(type);
    }

    public BigDecimal asNumberStripped() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        return this.number.stripTrailingZeros();
    }

    private void checkNumber(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }

    private boolean isOne(Number number) {
        BigDecimal bd = NumberUtils.getBigDecimal(number);
        try {
            return bd.scale() == 0 && bd.longValueExact() == 1L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public RoundedAmount(Number number, Unit unit) {
        this(number, unit, null, null);
    }

    @Deprecated
    public RoundedAmount(Number number, Unit unit, MathContext mathContext) {
        this(number, unit, DEFAULT_CONTEXT.toBuilder().roundingMode(mathContext.getRoundingMode()).mathContext(mathContext).build(), null);
    }

    public RoundedAmount(Number number, Unit unit, AmountContext mathContext) {
        this(number, unit, mathContext, null);
    }

    public RoundedAmount(Number number, Unit unit, Operator rounding) {
        this(number, unit, null, rounding);
    }

    @Deprecated
    public RoundedAmount(Number number, Unit unit, AmountContext context, Operator rounding) {
        Objects.requireNonNull(unit, "Currency is required.");
        this.unit = unit;
        this.rounding = rounding;
        Objects.requireNonNull(number, "Number is required.");
        this.checkNumber(number);
        this.amountContext = context == null ? DEFAULT_CONTEXT : AmountContext.builder().build();
        this.number = NumberUtils.getBigDecimal(number, this.amountContext);
    }

    public static RoundedAmount of(BigDecimal number, Unit unit) {
        return new RoundedAmount(number, unit);
    }

    public static RoundedAmount of(BigDecimal number, Unit unit, Operator rounding) {
        return new RoundedAmount((Number)number, unit, rounding);
    }

    public static RoundedAmount of(BigDecimal number, Unit unit, MathContext mathContext) {
        return new RoundedAmount((Number)number, unit, mathContext);
    }

    public static RoundedAmount of(Number number, Unit unit, Operator rounding) {
        return new RoundedAmount(number, unit, rounding);
    }

    public static RoundedAmount of(Number number, Unit unit, AmountContext amountContext) {
        return new RoundedAmount(number, unit, amountContext);
    }

    @Deprecated
    public static RoundedAmount of(Unit unit, Number number, AmountContext amountContext, Operator rounding) {
        return new RoundedAmount(number, unit, amountContext, rounding);
    }

    @Deprecated
    public static RoundedAmount of(Number number, String unitCode) {
        return new RoundedAmount(number, Piece.of(unitCode));
    }

    public static RoundedAmount of(Number number, String unitCode, Operator rounding) {
        return new RoundedAmount(number, (Unit)Piece.of(unitCode), rounding);
    }

    @Deprecated
    public static RoundedAmount of(Number number, String unitCode, AmountContext amountContext) {
        return new RoundedAmount(number, (Unit)Piece.of(unitCode), amountContext);
    }

    public static RoundedAmount of(String unitCode, Number number, AmountContext amountContext, Operator rounding) {
        return new RoundedAmount(number, Piece.of(unitCode), amountContext, rounding);
    }

    public static RoundedAmount zero(Unit unit) {
        return RoundedAmount.of(BigDecimal.ZERO, unit);
    }

    public static RoundedAmount ofMinor(Unit unit, long amountMinor) {
        return RoundedAmount.ofMinor(unit, amountMinor, unit.getDefaultFractionDigits());
    }

    public static RoundedAmount ofMinor(Unit unit, long amountMinor, int factionDigits) {
        if (factionDigits < 0) {
            throw new IllegalArgumentException("The factionDigits cannot be negative");
        }
        return RoundedAmount.of(BigDecimal.valueOf(amountMinor, factionDigits), unit);
    }

    public static RoundedAmount from(Quantity amt) {
        if (amt.getClass() == RoundedAmount.class) {
            return (RoundedAmount)amt;
        }
        if (amt.getClass() == Amount.class) {
            return RoundedAmount.of(amt.getNumber().numberValue(BigDecimal.class), amt.getUnit());
        }
        if (amt.getClass() == BigAmount.class) {
            return RoundedAmount.of(amt.getNumber().numberValue(BigDecimal.class), amt.getUnit());
        }
        return RoundedAmount.of(amt.getNumber().numberValue(BigDecimal.class), amt.getUnit());
    }

    public static RoundedAmount parse(CharSequence text) {
        String[] array = Objects.requireNonNull(text).toString().split(" ");
        if (array.length != 2) {
            throw new AmountParseException("An error happened when try to parse the Amount.", text, 0);
        }
        String parsed_unit = array[0];
        BigDecimal number = new BigDecimal(array[1]);
        return RoundedAmount.of(number, Piece.of(parsed_unit));
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public AmountContext getContext() {
        return this.amountContext;
    }

    @Override
    public RoundedAmount abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    @Override
    public RoundedAmount add(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        if (amount.isZero()) {
            return this;
        }
        return new RoundedAmount((Number)this.number.add(amount.getNumber().numberValue(BigDecimal.class)), this.unit, this.rounding).with(this.rounding);
    }

    @Override
    public RoundedAmount divide(Number divisor) {
        BigDecimal bd = NumberUtils.getBigDecimal(divisor);
        if (this.isOne(bd)) {
            return this;
        }
        BigDecimal dec = this.number.divide(bd, Optional.ofNullable(this.amountContext.getRoundingMode()).orElse(RoundingMode.HALF_EVEN));
        return new RoundedAmount((Number)dec, this.unit, this.rounding).with(this.rounding);
    }

    public RoundedAmount[] divideAndRemainder(Number divisor) {
        BigDecimal bd = NumberUtils.getBigDecimal(divisor);
        if (this.isOne(bd)) {
            return new RoundedAmount[]{this, new RoundedAmount((Number)0L, this.getUnit(), this.rounding)};
        }
        BigDecimal[] dec = this.number.divideAndRemainder(NumberUtils.getBigDecimal(divisor), Optional.ofNullable(this.amountContext.getMathContext()).orElse(MathContext.DECIMAL64));
        return new RoundedAmount[]{new RoundedAmount((Number)dec[0], this.unit, this.rounding), new RoundedAmount((Number)dec[1], this.unit, this.rounding).with(this.rounding)};
    }

    @Override
    public RoundedAmount divideToIntegralValue(Number divisor) {
        BigDecimal dec = this.number.divideToIntegralValue(NumberUtils.getBigDecimal(divisor), Optional.ofNullable(this.amountContext.getMathContext()).orElse(MathContext.DECIMAL64));
        return new RoundedAmount((Number)dec, this.unit, this.rounding);
    }

    @Override
    public RoundedAmount multiply(Number multiplicand) {
        BigDecimal bd = NumberUtils.getBigDecimal(multiplicand);
        if (this.isOne(bd)) {
            return this;
        }
        BigDecimal dec = this.number.multiply(bd, Optional.ofNullable(this.amountContext.getMathContext()).orElse(MathContext.DECIMAL64));
        return new RoundedAmount((Number)dec, this.unit, this.rounding).with(this.rounding);
    }

    @Override
    public RoundedAmount negate() {
        return new RoundedAmount((Number)this.number.negate(Optional.ofNullable(this.amountContext.getMathContext()).orElse(MathContext.DECIMAL64)), this.unit, this.rounding);
    }

    @Override
    public RoundedAmount plus() {
        return this;
    }

    @Override
    public RoundedAmount subtract(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        if (amount.isZero()) {
            return this;
        }
        return new RoundedAmount((Number)this.number.subtract(amount.getNumber().numberValue(BigDecimal.class), Optional.ofNullable(this.amountContext.getMathContext()).orElse(MathContext.DECIMAL64)), this.unit, this.rounding);
    }

    @Override
    public RoundedAmount remainder(Number divisor) {
        return new RoundedAmount((Number)this.number.remainder(NumberUtils.getBigDecimal(divisor), Optional.ofNullable(this.amountContext.getMathContext()).orElse(MathContext.DECIMAL64)), this.unit, this.rounding);
    }

    @Override
    public RoundedAmount scaleByPowerOfTen(int power) {
        return new RoundedAmount((Number)this.number.scaleByPowerOfTen(power), this.unit, this.rounding);
    }

    @Override
    public boolean isZero() {
        return this.number.signum() == 0;
    }

    @Override
    public boolean isPositive() {
        return this.signum() == 1;
    }

    @Override
    public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    @Override
    public boolean isNegative() {
        return this.signum() == -1;
    }

    @Override
    public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    @Override
    public int signum() {
        return this.number.signum();
    }

    @Override
    public boolean isLessThan(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) <= 0;
    }

    @Override
    public boolean isGreaterThan(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) >= 0;
    }

    @Override
    public boolean isEqualTo(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) == 0;
    }

    public boolean isNotEqualTo(Quantity amount) {
        NumberUtils.checkAmountParameter(amount, this.unit);
        return this.number.stripTrailingZeros().compareTo(amount.getNumber().numberValue(BigDecimal.class).stripTrailingZeros()) != 0;
    }

    @Override
    public RoundedAmount with(Operator operator) {
        Objects.requireNonNull(operator);
        try {
            return RoundedAmount.from(operator.apply(this));
        }
        catch (ArithmeticException | ValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueException("Query failed: " + operator, e);
        }
    }

    public String toString() {
        return this.unit.getCode() + " " + this.number;
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.asNumberStripped());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RoundedAmount) {
            RoundedAmount other = (RoundedAmount)obj;
            return Objects.equals(this.unit, other.unit) && Objects.equals(this.asNumberStripped(), other.asNumberStripped());
        }
        return false;
    }

    @Override
    public int compareTo(Quantity o) {
        Objects.requireNonNull(o);
        int compare = this.unit.equals(o.getUnit()) ? this.asNumberStripped().compareTo(RoundedAmount.from(o).asNumberStripped()) : this.unit.getCode().compareTo(o.getUnit().getCode());
        return compare;
    }

    @Override
    public NumberValue getNumber() {
        return new DefaultNumberValue(this.number);
    }

    @Override
    public RoundedAmount multiply(long multiplicand) {
        if (multiplicand == 1L) {
            return this;
        }
        return this.multiply(NumberUtils.getBigDecimal(multiplicand));
    }

    @Override
    public RoundedAmount multiply(double multiplicand) {
        NumberUtils.checkNoInfinityOrNaN(multiplicand);
        if (multiplicand == 1.0) {
            return this;
        }
        return this.multiply(NumberUtils.getBigDecimal(multiplicand));
    }

    @Override
    public RoundedAmount divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divide(NumberUtils.getBigDecimal(divisor));
    }

    @Override
    public RoundedAmount divide(double divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return new RoundedAmount(0L, this.getUnit(), this.amountContext, this.rounding);
        }
        if (divisor == 1.0) {
            return this;
        }
        return this.divide(NumberUtils.getBigDecimal(divisor));
    }

    @Override
    public RoundedAmount remainder(long divisor) {
        return this.remainder(NumberUtils.getBigDecimal(divisor));
    }

    @Override
    public RoundedAmount remainder(double divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            return new RoundedAmount(0L, this.getUnit(), this.amountContext, this.rounding);
        }
        return this.remainder(NumberUtils.getBigDecimal(divisor));
    }

    public RoundedAmount[] divideAndRemainder(long divisor) {
        return this.divideAndRemainder(NumberUtils.getBigDecimal(divisor));
    }

    public RoundedAmount[] divideAndRemainder(double divisor) {
        if (NumberUtils.isInfinityAndNotNaN(divisor)) {
            RoundedAmount zero = new RoundedAmount(0L, this.getUnit(), this.amountContext, this.rounding);
            return new RoundedAmount[]{zero, zero};
        }
        return this.divideAndRemainder(NumberUtils.getBigDecimal(divisor));
    }

    @Override
    public RoundedAmount stripTrailingZeros() {
        if (this.isZero()) {
            return RoundedAmount.of(BigDecimal.ZERO, this.getUnit());
        }
        return RoundedAmount.of(this.number.stripTrailingZeros(), this.getUnit());
    }

    @Override
    public RoundedAmount divideToIntegralValue(long divisor) {
        return this.divideToIntegralValue(NumberUtils.getBigDecimal(divisor));
    }

    @Override
    public RoundedAmount divideToIntegralValue(double divisor) {
        return this.divideToIntegralValue(NumberUtils.getBigDecimal(divisor));
    }
}

