/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.context;

import java.math.MathContext;
import java.math.RoundingMode;
import life.expert.value.numeric.amount.Quantity;
import life.expert.value.numeric.context.Context;
import lombok.NonNull;

public final class AmountContext
implements Context {
    @NonNull
    private final Class<? extends Quantity> quantityType;
    private final int precision;
    private final boolean fixedScale;
    private final int maxScale;
    @NonNull
    private final RoundingMode roundingMode;
    private final MathContext mathContext;

    public static final AmountContext of(@NonNull Class<? extends Quantity> quantityType, int precision, boolean fixedScale, int maxScale, @NonNull RoundingMode roundingMode) {
        if (quantityType == null) {
            throw new NullPointerException("quantityType is marked non-null but is null");
        }
        if (roundingMode == null) {
            throw new NullPointerException("roundingMode is marked non-null but is null");
        }
        return AmountContext.of(quantityType, precision, fixedScale, maxScale, roundingMode);
    }

    public static AmountContextBuilder builder() {
        return new AmountContextBuilder();
    }

    public AmountContextBuilder toBuilder() {
        return new AmountContextBuilder().quantityType(this.quantityType).precision(this.precision).fixedScale(this.fixedScale).maxScale(this.maxScale).roundingMode(this.roundingMode).mathContext(this.mathContext);
    }

    @NonNull
    public Class<? extends Quantity> getQuantityType() {
        return this.quantityType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isFixedScale() {
        return this.fixedScale;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    @NonNull
    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmountContext)) {
            return false;
        }
        AmountContext other = (AmountContext)o;
        Class<? extends Quantity> this$quantityType = this.getQuantityType();
        Class<? extends Quantity> other$quantityType = other.getQuantityType();
        if (this$quantityType == null ? other$quantityType != null : !this$quantityType.equals(other$quantityType)) {
            return false;
        }
        if (this.getPrecision() != other.getPrecision()) {
            return false;
        }
        if (this.isFixedScale() != other.isFixedScale()) {
            return false;
        }
        if (this.getMaxScale() != other.getMaxScale()) {
            return false;
        }
        RoundingMode this$roundingMode = this.getRoundingMode();
        RoundingMode other$roundingMode = other.getRoundingMode();
        if (this$roundingMode == null ? other$roundingMode != null : !((Object)((Object)this$roundingMode)).equals((Object)other$roundingMode)) {
            return false;
        }
        MathContext this$mathContext = this.getMathContext();
        MathContext other$mathContext = other.getMathContext();
        return !(this$mathContext == null ? other$mathContext != null : !((Object)this$mathContext).equals(other$mathContext));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends Quantity> $quantityType = this.getQuantityType();
        result = result * 59 + ($quantityType == null ? 43 : $quantityType.hashCode());
        result = result * 59 + this.getPrecision();
        result = result * 59 + (this.isFixedScale() ? 79 : 97);
        result = result * 59 + this.getMaxScale();
        RoundingMode $roundingMode = this.getRoundingMode();
        result = result * 59 + ($roundingMode == null ? 43 : ((Object)((Object)$roundingMode)).hashCode());
        MathContext $mathContext = this.getMathContext();
        result = result * 59 + ($mathContext == null ? 43 : ((Object)$mathContext).hashCode());
        return result;
    }

    public String toString() {
        return "AmountContext(" + this.getQuantityType() + ", " + this.getPrecision() + ", " + this.isFixedScale() + ", " + this.getMaxScale() + ", " + this.getRoundingMode() + ", " + this.getMathContext() + ")";
    }

    private AmountContext(@NonNull Class<? extends Quantity> quantityType, int precision, boolean fixedScale, int maxScale, @NonNull RoundingMode roundingMode, MathContext mathContext) {
        if (quantityType == null) {
            throw new NullPointerException("quantityType is marked non-null but is null");
        }
        if (roundingMode == null) {
            throw new NullPointerException("roundingMode is marked non-null but is null");
        }
        this.quantityType = quantityType;
        this.precision = precision;
        this.fixedScale = fixedScale;
        this.maxScale = maxScale;
        this.roundingMode = roundingMode;
        this.mathContext = mathContext;
    }

    public static AmountContext of(@NonNull Class<? extends Quantity> quantityType, int precision, boolean fixedScale, int maxScale, @NonNull RoundingMode roundingMode, MathContext mathContext) {
        return new AmountContext(quantityType, precision, fixedScale, maxScale, roundingMode, mathContext);
    }

    public static class AmountContextBuilder {
        private Class<? extends Quantity> quantityType;
        private int precision;
        private boolean fixedScale;
        private int maxScale;
        private RoundingMode roundingMode;
        private MathContext mathContext;

        AmountContextBuilder() {
        }

        public AmountContextBuilder quantityType(@NonNull Class<? extends Quantity> quantityType) {
            if (quantityType == null) {
                throw new NullPointerException("quantityType is marked non-null but is null");
            }
            this.quantityType = quantityType;
            return this;
        }

        public AmountContextBuilder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public AmountContextBuilder fixedScale(boolean fixedScale) {
            this.fixedScale = fixedScale;
            return this;
        }

        public AmountContextBuilder maxScale(int maxScale) {
            this.maxScale = maxScale;
            return this;
        }

        public AmountContextBuilder roundingMode(@NonNull RoundingMode roundingMode) {
            if (roundingMode == null) {
                throw new NullPointerException("roundingMode is marked non-null but is null");
            }
            this.roundingMode = roundingMode;
            return this;
        }

        public AmountContextBuilder mathContext(MathContext mathContext) {
            this.mathContext = mathContext;
            return this;
        }

        public AmountContext build() {
            return new AmountContext(this.quantityType, this.precision, this.fixedScale, this.maxScale, this.roundingMode, this.mathContext);
        }

        public String toString() {
            return "AmountContext.AmountContextBuilder(quantityType=" + this.quantityType + ", precision=" + this.precision + ", fixedScale=" + this.fixedScale + ", maxScale=" + this.maxScale + ", roundingMode=" + this.roundingMode + ", mathContext=" + this.mathContext + ")";
        }
    }
}

