/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.unit;

import com.google.common.collect.ComparisonChain;
import java.util.Map;
import life.expert.value.numeric.context.PieceContext;
import life.expert.value.numeric.unit.Unit;
import lombok.NonNull;

public final class Piece
implements Unit,
Comparable<Unit> {
    public static final PieceContext DEFAULT_CONTEXT = PieceContext.of(Map.of());
    @NonNull
    private final String code;
    private final int numericCode;
    private final int defaultFractionDigits;
    @NonNull
    private final PieceContext context;

    public static final Piece of(@NonNull String code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return Piece.builder().code(code).build();
    }

    @Override
    public int compareTo(Unit o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getCode()), (Comparable)((Object)o.getCode())).result();
    }

    private static int $default$numericCode() {
        return -1;
    }

    private static int $default$defaultFractionDigits() {
        return 0;
    }

    private static PieceContext $default$context() {
        return DEFAULT_CONTEXT;
    }

    public static PieceBuilder builder() {
        return new PieceBuilder();
    }

    public PieceBuilder toBuilder() {
        return new PieceBuilder().code(this.code).numericCode(this.numericCode).defaultFractionDigits(this.defaultFractionDigits).context(this.context);
    }

    @Override
    @NonNull
    public String getCode() {
        return this.code;
    }

    @Override
    public int getNumericCode() {
        return this.numericCode;
    }

    @Override
    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    @Override
    @NonNull
    public PieceContext getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Piece)) {
            return false;
        }
        Piece other = (Piece)o;
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        if (this.getNumericCode() != other.getNumericCode()) {
            return false;
        }
        if (this.getDefaultFractionDigits() != other.getDefaultFractionDigits()) {
            return false;
        }
        PieceContext this$context = this.getContext();
        PieceContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        result = result * 59 + this.getNumericCode();
        result = result * 59 + this.getDefaultFractionDigits();
        PieceContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "Piece(" + this.getCode() + ", " + this.getNumericCode() + ", " + this.getDefaultFractionDigits() + ", " + this.getContext() + ")";
    }

    private Piece(@NonNull String code, int numericCode, int defaultFractionDigits, @NonNull PieceContext context) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.code = code;
        this.numericCode = numericCode;
        this.defaultFractionDigits = defaultFractionDigits;
        this.context = context;
    }

    public static Piece of(@NonNull String code, int numericCode, int defaultFractionDigits, @NonNull PieceContext context) {
        return new Piece(code, numericCode, defaultFractionDigits, context);
    }

    public static class PieceBuilder {
        private String code;
        private boolean numericCode$set;
        private int numericCode$value;
        private boolean defaultFractionDigits$set;
        private int defaultFractionDigits$value;
        private boolean context$set;
        private PieceContext context$value;

        PieceBuilder() {
        }

        public PieceBuilder code(@NonNull String code) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            this.code = code;
            return this;
        }

        public PieceBuilder numericCode(int numericCode) {
            this.numericCode$value = numericCode;
            this.numericCode$set = true;
            return this;
        }

        public PieceBuilder defaultFractionDigits(int defaultFractionDigits) {
            this.defaultFractionDigits$value = defaultFractionDigits;
            this.defaultFractionDigits$set = true;
            return this;
        }

        public PieceBuilder context(@NonNull PieceContext context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            this.context$value = context;
            this.context$set = true;
            return this;
        }

        public Piece build() {
            int numericCode$value = this.numericCode$value;
            if (!this.numericCode$set) {
                numericCode$value = Piece.$default$numericCode();
            }
            int defaultFractionDigits$value = this.defaultFractionDigits$value;
            if (!this.defaultFractionDigits$set) {
                defaultFractionDigits$value = Piece.$default$defaultFractionDigits();
            }
            PieceContext context$value = this.context$value;
            if (!this.context$set) {
                context$value = Piece.$default$context();
            }
            return new Piece(this.code, numericCode$value, defaultFractionDigits$value, context$value);
        }

        public String toString() {
            return "Piece.PieceBuilder(code=" + this.code + ", numericCode$value=" + this.numericCode$value + ", defaultFractionDigits$value=" + this.defaultFractionDigits$value + ", context$value=" + this.context$value + ")";
        }
    }
}

