/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import life.expert.value.numeric.utils.ConvertBigDecimal;
import life.expert.value.numeric.utils.ConvertNumberValue;
import life.expert.value.numeric.utils.NumberValue;

public final class DefaultNumberValue
extends NumberValue {
    private final Number number;
    public static final NumberValue ONE = new DefaultNumberValue(BigDecimal.ONE);

    public DefaultNumberValue(Number number) {
        this.number = Objects.requireNonNull(number, "Number required");
    }

    public static NumberValue of(Number number) {
        return new DefaultNumberValue(number);
    }

    @Override
    public Class<?> getNumberType() {
        return this.number.getClass();
    }

    @Override
    public int getPrecision() {
        return this.numberValue(BigDecimal.class).precision();
    }

    @Override
    public int getScale() {
        return ConvertBigDecimal.of(this.number).scale();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public int intValueExact() {
        return ConvertBigDecimal.of(this.number).intValueExact();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public long longValueExact() {
        return ConvertBigDecimal.of(this.number).longValueExact();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public double doubleValueExact() {
        double d = this.number.doubleValue();
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            throw new ArithmeticException("Unable to convert to double: " + this.number);
        }
        return d;
    }

    @Override
    public long getAmountFractionNumerator() {
        BigDecimal bd = ConvertBigDecimal.of(this.number).remainder(BigDecimal.ONE);
        return bd.movePointRight(this.getScale()).longValueExact();
    }

    @Override
    public long getAmountFractionDenominator() {
        return this.getScale() < 0 ? 1L : BigDecimal.valueOf(10L).pow(this.getScale()).longValueExact();
    }

    @Override
    public <T extends Number> T numberValue(Class<T> numberType) {
        return ConvertNumberValue.of(numberType, this.number);
    }

    @Override
    public NumberValue round(MathContext mathContext) {
        if (this.number instanceof BigDecimal) {
            return new DefaultNumberValue(((BigDecimal)this.number).round(mathContext));
        }
        return new DefaultNumberValue(new BigDecimal(this.number.toString()).round(mathContext));
    }

    @Override
    public <T extends Number> T numberValueExact(Class<T> numberType) {
        return ConvertNumberValue.ofExact(numberType, this.number);
    }

    @Deprecated
    protected static BigDecimal getBigDecimal(Number num) {
        return ConvertBigDecimal.of(num);
    }

    public String toString() {
        return String.valueOf(this.number);
    }
}

