/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.utils;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import life.expert.value.numeric.amount.Quantity;
import life.expert.value.numeric.context.AmountContext;
import life.expert.value.numeric.unit.Unit;
import life.expert.value.numeric.utils.ConvertBigDecimal;
import life.expert.value.numeric.utils.ValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberUtils {
    private static final Logger logger_ = LoggerFactory.getLogger(NumberUtils.class);

    public static BigDecimal getBigDecimal(long num) {
        return BigDecimal.valueOf(num);
    }

    public static BigDecimal getBigDecimal(double num) {
        if (Double.isNaN(num)) {
            throw new ArithmeticException("Invalid input Double.NaN.");
        }
        if (Double.isInfinite(num)) {
            throw new ArithmeticException("Invalid input Double.xxx_INFINITY.");
        }
        return new BigDecimal(String.valueOf(num));
    }

    public static BigDecimal getBigDecimal(Number num) {
        return ConvertBigDecimal.of(num);
    }

    public static BigDecimal getBigDecimal(Number num, AmountContext amountContext) {
        BigDecimal bd = NumberUtils.getBigDecimal(num);
        if (Objects.nonNull(amountContext)) {
            MathContext mc = NumberUtils.getMathContext(amountContext, RoundingMode.HALF_EVEN);
            bd = new BigDecimal(bd.toString(), mc);
            if (amountContext.getMaxScale() > 0) {
                logger_.trace("Got Max Scale {}", (Object)amountContext.getMaxScale());
                bd = bd.setScale(amountContext.getMaxScale(), mc.getRoundingMode());
            }
        }
        return bd;
    }

    public static MathContext getMathContext(AmountContext amountContext, RoundingMode defaultMode) {
        MathContext ctx = amountContext.getMathContext();
        if (Objects.nonNull(ctx)) {
            return ctx;
        }
        RoundingMode roundingMode = amountContext.getRoundingMode();
        if (roundingMode == null) {
            roundingMode = Optional.ofNullable(defaultMode).orElse(RoundingMode.HALF_EVEN);
        }
        return new MathContext(amountContext.getPrecision(), roundingMode);
    }

    public static void checkAmountParameter(Quantity amount, Unit unit) {
        Objects.requireNonNull(amount, "Amount must not be null.");
        Unit unit_of_amount = amount.getUnit();
        if (!unit.getCode().equals(unit_of_amount.getCode())) {
            throw new ValueException("Currency mismatch: " + unit + "/" + unit_of_amount);
        }
    }

    public static void checkNumberParameter(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }

    public static void checkNoInfinityOrNaN(Number number) {
        if (Double.class != number.getClass() && Float.class != number.getClass()) {
            return;
        }
        double dValue = number.doubleValue();
        if (Double.isNaN(dValue)) {
            throw new ArithmeticException("Not a valid input: NaN.");
        }
        if (Double.isInfinite(dValue)) {
            throw new ArithmeticException("Not a valid input: INFINITY: " + dValue);
        }
    }

    public static boolean isInfinityAndNotNaN(Number number) {
        if (Double.class != number.getClass() && Float.class != number.getClass()) {
            return false;
        }
        double dValue = number.doubleValue();
        if (Double.isNaN(dValue)) {
            throw new ArithmeticException("Not a valid input: NaN.");
        }
        return Double.isInfinite(dValue);
    }

    private NumberUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

