/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.numeric.utils;

import java.util.Locale;
import java.util.Objects;
import life.expert.value.numeric.utils.ValueException;

public class UnknownUnitException
extends ValueException {
    private final String currencyCode;
    private final Locale locale;

    public UnknownUnitException(String code) {
        super("Unknown currency code: " + code);
        this.currencyCode = code;
        this.locale = null;
    }

    public UnknownUnitException(Locale locale) {
        super("No currency for found for Locale: " + locale);
        this.locale = locale;
        this.currencyCode = null;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String toString() {
        if (Objects.isNull(this.locale)) {
            return "UnknownCurrencyException [currencyCode=" + this.currencyCode + "]";
        }
        return "UnknownCurrencyException [locale=" + this.locale + "]";
    }
}

