/*
 * Decompiled with CFR 0.152.
 */
package life.expert.value.string;

import com.google.common.collect.ComparisonChain;
import io.vavr.Tuple;
import io.vavr.Tuple1;
import io.vavr.match.annotation.Patterns;
import io.vavr.match.annotation.Unapply;
import life.expert.common.function.TupleUtils;
import life.expert.common.reactivestreams.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Patterns
public final class SolidString
implements Comparable<SolidString> {
    private static final Logger logger_ = LoggerFactory.getLogger(SolidString.class);
    private final String string;

    private static Mono<SolidString> monoOf_(String string) {
        return Mono.fromSupplier(() -> new SolidString(string));
    }

    public static Mono<SolidString> monoOf(String string) {
        if (string == null) {
            return Preconditions.illegalArgumentMonoError("String must not be null.");
        }
        if (string.isBlank()) {
            return Preconditions.illegalArgumentMonoError("String must not be blank.");
        }
        return SolidString.monoOf_(string.strip());
    }

    @Deprecated
    public static SolidString of(String string) {
        return (SolidString)SolidString.monoOf(string).block();
    }

    public static Mono<SolidString> monoOfTuple(Tuple1<String> tuple) {
        if (tuple == null) {
            return Preconditions.illegalArgumentMonoError("Input tuple must not be null.");
        }
        return TupleUtils.function(SolidString::monoOf).apply(tuple);
    }

    public static Mono<SolidString> monoOfMonoWithTuple(Mono<Tuple1<String>> tuple) {
        if (tuple == null) {
            return Preconditions.illegalArgumentMonoError("Input Mono must not be null.");
        }
        return tuple.flatMap(SolidString::monoOfTuple);
    }

    public static Mono<SolidString> monoOfMono(Mono<String> string) {
        if (string == null) {
            return Preconditions.illegalArgumentMonoError("Input Mono must not be null.");
        }
        return string.flatMap(SolidString::monoOf);
    }

    public static Mono<SolidString> copyOf(SolidString other) {
        return SolidString.monoOf_(other.getString());
    }

    @Override
    public int compareTo(SolidString o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.string), (Comparable)((Object)o.string)).result();
    }

    public String toString() {
        return this.string;
    }

    @Unapply
    public static Tuple1<String> SolidString(SolidString object) {
        return Tuple.of((Object)object.getString());
    }

    public static SolidStringBuilder builder() {
        return new SolidStringBuilder();
    }

    public SolidStringBuilder toBuilder() {
        return new SolidStringBuilder().append(this.string.toString());
    }

    public String getString() {
        return this.string;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolidString)) {
            return false;
        }
        SolidString other = (SolidString)o;
        String this$string = this.getString();
        String other$string = other.getString();
        return !(this$string == null ? other$string != null : !this$string.equals(other$string));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $string = this.getString();
        result = result * 59 + ($string == null ? 43 : $string.hashCode());
        return result;
    }

    private SolidString(String string) {
        this.string = string;
    }

    public static class SolidStringBuilder {
        private StringBuilder string = new StringBuilder();

        SolidStringBuilder() {
        }

        public SolidStringBuilder append(String string) {
            this.string.append(string);
            return this;
        }

        @Deprecated
        public SolidString build() {
            return SolidString.of(this.string.toString());
        }

        public Mono<SolidString> buildMono() {
            return SolidString.monoOf(this.string.toString());
        }

        public String toString() {
            return this.string.toString();
        }
    }
}

