/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0016H\u0002R\u001c\u0010\u0005\u001a\u00020\u00038FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"LSalesforceAuth;", "", "refreshToken", "", "(Ljava/lang/String;)V", "accessToken", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "instanceUrl", "getInstanceUrl", "setInstanceUrl", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "validUntil", "Ljava/time/ZonedDateTime;", "LAuthResponse;", "isValid", "", "update", "", "getResponse", "Ljava/net/HttpURLConnection;", "salesforce-utils-kotlin"})
@SourceDebugExtension(value={"SMAP\nSalesforceAuth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SalesforceAuth.kt\nSalesforceAuth\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class SalesforceAuth {
    @NotNull
    private final String refreshToken;
    @NotNull
    private String accessToken;
    @NotNull
    private String instanceUrl;
    @NotNull
    private ZonedDateTime validUntil;
    @NotNull
    private ObjectMapper mapper;

    public SalesforceAuth(@NotNull String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        this.refreshToken = refreshToken;
        ObjectMapper objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)ExtensionsKt.jacksonObjectMapper()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"configure(...)");
        this.mapper = objectMapper;
        AuthResponse response = this.getAccessToken();
        this.accessToken = response.getAccessToken();
        this.instanceUrl = response.getInstanceUrl();
        ZonedDateTime zonedDateTime = ZonedDateTime.now().plusHours(2L).minusMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"minusMinutes(...)");
        this.validUntil = zonedDateTime;
    }

    public /* synthetic */ SalesforceAuth(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "yourRefreshToken";
        }
        this(string);
    }

    @NotNull
    public final String getAccessToken() {
        if (!this.isValid()) {
            this.update();
        }
        return this.accessToken;
    }

    public final void setAccessToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.accessToken = string;
    }

    @NotNull
    public final String getInstanceUrl() {
        return this.instanceUrl;
    }

    public final void setInstanceUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.instanceUrl = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AuthResponse getAccessToken() {
        HttpURLConnection httpURLConnection;
        URL url = new URL("http://api.codegen.link/salesforce/login/refresh");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection it = httpURLConnection = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        it.setRequestProperty("Content-Type", "application/json");
        it.setRequestProperty("Accept", "application/json");
        it.setRequestMethod("POST");
        it.setDoOutput(true);
        HttpURLConnection connection = httpURLConnection;
        AuthRequest requestBody = new AuthRequest(this.refreshToken);
        Closeable closeable = new DataOutputStream(connection.getOutputStream());
        Throwable throwable = null;
        try {
            DataOutputStream it2 = (DataOutputStream)closeable;
            boolean bl2 = false;
            it2.writeBytes(this.mapper.writeValueAsString((Object)requestBody));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this.getResponse(connection);
    }

    private final AuthResponse getResponse(HttpURLConnection $this$getResponse) {
        int responseCode = $this$getResponse.getResponseCode();
        boolean bl = 200 <= responseCode ? responseCode < 300 : false;
        if (bl) {
            Object object = this.mapper.readValue($this$getResponse.getInputStream(), (TypeReference)new TypeReference<AuthResponse>(){});
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (AuthResponse)object;
        }
        InputStream inputStream = $this$getResponse.getErrorStream();
        if (inputStream == null) {
            throw new Exception("No error stream available");
        }
        InputStream errorStream = inputStream;
        ErrorResponse errorResponse = (ErrorResponse)this.mapper.readValue(errorStream, ErrorResponse.class);
        String errorMessage = errorResponse.getMessage();
        if (responseCode == 400) {
            throw new IllegalArgumentException(errorMessage);
        }
        throw new InternalError("Unexpected error occurred: " + errorMessage);
    }

    private final boolean isValid() {
        return this.validUntil.compareTo(ZonedDateTime.now()) > 0;
    }

    private final void update() {
        AuthResponse response = this.getAccessToken();
        this.accessToken = response.getAccessToken();
        this.instanceUrl = response.getInstanceUrl();
        ZonedDateTime zonedDateTime = ZonedDateTime.now().plusHours(2L).minusMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"minusMinutes(...)");
        this.validUntil = zonedDateTime;
    }

    public SalesforceAuth() {
        this(null, 1, null);
    }
}

